/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.property.model.aspects;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.ConfPackage;
import org.eclipse.jwt.we.conf.model.aspects.factory.RegistryAspectFactory;
import org.eclipse.jwt.we.conf.property.model.property.Property;
import org.eclipse.jwt.we.conf.property.model.property.PropertyPackage;

public class PropertyAspectFactory
implements RegistryAspectFactory {
    public static PropertyAspectFactory INSTANCE = null;

    public PropertyAspectFactory() {
        INSTANCE = this;
    }

    public boolean isFactoryFor(Aspect aspect) {
        EClassifier aspectInstanceETypeEClassifier = aspect.getAspectInstanceEType();
        return aspectInstanceETypeEClassifier instanceof EDataType || aspectInstanceETypeEClassifier instanceof EClass && !ConfPackage.eINSTANCE.getAspectInstance().isSuperTypeOf((EClass)aspectInstanceETypeEClassifier);
    }

    public AspectInstance createAspectInstance(Aspect aspect, EObject modelElement) {
        EClassifier aspectInstanceETypeEClassifier = aspect.getAspectInstanceEType();
        if (aspectInstanceETypeEClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)aspectInstanceETypeEClassifier;
            return this.createAspectDataProperty(eDataType, aspect.getDefaultValue());
        }
        if (aspectInstanceETypeEClassifier instanceof EClass) {
            EClass aspectInstanceEClass = (EClass)aspectInstanceETypeEClassifier;
            return this.createAspectObjectProperty(aspectInstanceEClass);
        }
        return null;
    }

    public Property createAspectDataProperty(EDataType eDataType, String defaultStringValue) {
        Property property = PropertyPackage.eINSTANCE.getPropertyFactory().createProperty();
        Object propertyValue = this.createDefaultValue(eDataType, defaultStringValue);
        if (propertyValue != null) {
            property.setValue(propertyValue);
        }
        return property;
    }

    public Object createDefaultValue(EDataType eDataType, String defaultStringValue) {
        if (eDataType.getInstanceClass() == String.class) {
            defaultStringValue = defaultStringValue == null ? "" : defaultStringValue;
        } else if (defaultStringValue == null || defaultStringValue.length() == 0) {
            if (eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE) {
                defaultStringValue = "true";
            } else if (eDataType.getInstanceClass() == Integer.class || eDataType.getInstanceClass() == Integer.TYPE || eDataType.getInstanceClass() == Byte.class || eDataType.getInstanceClass() == Byte.TYPE || eDataType.getInstanceClass() == Character.class || eDataType.getInstanceClass() == Character.TYPE || eDataType.getInstanceClass() == Short.class || eDataType.getInstanceClass() == Short.TYPE || eDataType.getInstanceClass() == Float.class || eDataType.getInstanceClass() == Float.TYPE || eDataType.getInstanceClass() == Double.class || eDataType.getInstanceClass() == Double.TYPE || eDataType.getInstanceClass() == BigDecimal.class) {
                defaultStringValue = "0";
            }
        }
        Object propertyValue = null;
        if (defaultStringValue != null) {
            propertyValue = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, defaultStringValue);
        } else if (eDataType.getInstanceClass() == Date.class) {
            propertyValue = new Date();
        }
        return propertyValue;
    }

    public Property createAspectObjectProperty(EClass aspectInstanceEClass) {
        EFactory propertyValueEFactory = aspectInstanceEClass.getEPackage().getEFactoryInstance();
        EObject defaultValue = propertyValueEFactory.create(aspectInstanceEClass);
        Property property = PropertyPackage.eINSTANCE.getPropertyFactory().createProperty();
        property.setValue(defaultValue);
        return property;
    }
}

