/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.xslt.tools;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.xslt.tools.CustomNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomXslFunctions {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String beforeOp = "^([^=<> ]+) ?";
    private static final String afterOp = " *([^&|\\(\\) ]+)([|&\\(\\) ]*)(.*)$";
    private static final Pattern patternVar = Pattern.compile("^(.*)([^\\.]+)\\.\\2(.*)$");
    private static final Pattern patternEqual = Pattern.compile("^([^=<> ]+) ?== *([^&|\\(\\) ]+)([|&\\(\\) ]*)(.*)$");
    private static final Pattern patternDifferent = Pattern.compile("^([^=<> ]+) ?!= *([^&|\\(\\) ]+)([|&\\(\\) ]*)(.*)$");
    private static final String ACTIVITY_NAME_PREFIX = "Activity";
    private static final String ROUTE_NAME_PREFIX = "Route";
    private static final String BLOCK_NAME_PREFIX = "Block";
    private static final String FINAL_NAME_PREFIX = "BonitaEnd-";
    private static HashSet<String> names = new HashSet();
    private static ThreadLocal<Properties> PROPERTIES = new ThreadLocal();
    private static ThreadLocal<Map<String, String>> RESOURCES = new ThreadLocal();

    public static void setContext(Properties properties, Map<String, String> resources) {
        PROPERTIES.set(properties);
        RESOURCES.set(resources);
    }

    public static String declareName(String name) {
        names.add(name);
        return "";
    }

    public static String generateActivityName() {
        return CustomXslFunctions.generateName(ACTIVITY_NAME_PREFIX);
    }

    public static String generateFinalName() {
        return CustomXslFunctions.generateName(FINAL_NAME_PREFIX);
    }

    public static String generateRouteName() {
        return CustomXslFunctions.generateName(ROUTE_NAME_PREFIX);
    }

    public static String generateBlockName() {
        return CustomXslFunctions.generateName(BLOCK_NAME_PREFIX);
    }

    private static String generateName(String prefix) {
        String name;
        int n = 1;
        do {
            name = String.valueOf(prefix) + n;
            ++n;
        } while (names.contains(name));
        CustomXslFunctions.declareName(name);
        return name;
    }

    public static String getDate() {
        return dateFormat.format(new Date());
    }

    public static void clear() {
        names.clear();
    }

    public static String getBlockId(Node structuredActivityNode) throws TransformationException {
        String name;
        Node nameNode = structuredActivityNode.getAttributes().getNamedItem("name");
        if (nameNode != null && (name = nameNode.getTextContent()) != null && name.length() > 0) {
            return name;
        }
        throw new TransformationException("The embedded subprocess must have a name.");
    }

    public static Node getNodes(String nodesEmfPaths, Node root) throws TransformationException {
        String[] emfNodes = nodesEmfPaths.split(" ");
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            throw new TransformationException("Could not create 'node' element", (Throwable)ex);
        }
        Element nodes = doc.createElement("res");
        int i = 0;
        while (i < emfNodes.length) {
            nodes.appendChild(doc.importNode(CustomXslFunctions.getNode(emfNodes[i], root), true));
            ++i;
        }
        return nodes;
    }

    private static Node getNode(String emfPath, Node root) throws TransformationException {
        try {
            String doc = CustomXslFunctions.createStringFromNode(root.getOwnerDocument());
            XPath xPath = CustomXslFunctions.getXPath();
            XPathExpression expression = xPath.compile(CustomXslFunctions.generateNodeXPath(emfPath).toString());
            Node res = (Node)expression.evaluate(new InputSource(new StringReader(doc)), XPathConstants.NODE);
            return res;
        }
        catch (Exception ex) {
            throw new TransformationException("Could not process node", (Throwable)ex);
        }
    }

    public static Node getValuesFromPath(Node nodePath, Node root) throws Exception {
        return CustomXslFunctions.getValuesFromPath(nodePath, root, "name");
    }

    public static Node getValuesFromPath(Node nodePath, Node root, String attribute) throws Exception {
        Element values = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        values = doc.createElement("values");
        String[] originalPaths = nodePath.getTextContent().split(" ");
        int i = 0;
        while (i < originalPaths.length) {
            String originalPath = originalPaths[i];
            if (originalPath != null && originalPath.trim().length() != 0) {
                String value = CustomXslFunctions.getValueFromPath(originalPath, root, attribute);
                Element valueNode = doc.createElement("value");
                valueNode.setTextContent(value);
                values.appendChild(valueNode);
            }
            ++i;
        }
        return values;
    }

    public static String getValueFromPath(Node nodePath, Node root) throws Exception {
        return CustomXslFunctions.getValueFromPath(nodePath, root, "name");
    }

    public static String getValueFromPath(Node nodePath, Node root, String attribute) throws Exception {
        try {
            String value = "";
            String text = nodePath.getTextContent();
            if (text == null && nodePath.getFirstChild() != null && nodePath.getFirstChild().getLocalName() != null && nodePath.getFirstChild().getLocalName().length() == 0) {
                text = nodePath.getFirstChild().getTextContent();
            }
            if (text == null) {
                throw new TransformationException("Could not get text for node [" + nodePath.getLocalName() + "]");
            }
            String[] originalPaths = text.split(" ");
            if (originalPaths.length > 1) {
                throw new Exception("There are " + originalPaths.length + " paths: use getValuesFromPath for \"" + text + "\"");
            }
            String originalPath = originalPaths[0];
            value = CustomXslFunctions.getValueFromPath(originalPath, root, attribute);
            return value;
        }
        catch (Exception ex) {
            return "ERROR(" + ex.getMessage() + ")";
        }
    }

    private static String getValueFromPath(String originalPath, Node root, String attribute) throws XPathExpressionException, TransformerException, TransformationException {
        StringBuilder xPathExpression = CustomXslFunctions.generateNodeXPath(originalPath);
        String xPathExpressionName = String.valueOf(xPathExpression.toString()) + "/@" + attribute;
        XPath xPath = CustomXslFunctions.getXPath();
        XPathExpression expression = xPath.compile(xPathExpressionName);
        String document = CustomXslFunctions.createStringFromNode(root);
        InputSource inputSource = new InputSource(new StringReader(document));
        String value = expression.evaluate(inputSource);
        return value;
    }

    private static XPath getXPath() throws TransformationException {
        XPathFactory xPathFactory = null;
        try {
            xPathFactory = XPathFactory.newInstance();
        }
        catch (Exception e) {
            throw new TransformationException("Wrong xpath/xslt configuration", (Throwable)e);
        }
        XPath xPath = xPathFactory.newXPath();
        HashMap<String, String> namespaces = CustomXslFunctions.getNamespaces();
        xPath.setNamespaceContext(new CustomNamespaceContext(namespaces));
        return xPath;
    }

    private static HashMap<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("core", "org.eclipse.jwt/core");
        namespaces.put("data", "org.eclipse.jwt/data");
        namespaces.put("processes", "org.eclipse.jwt/processes");
        return namespaces;
    }

    private static StringBuilder generateNodeXPath(String emfPath) {
        StringBuilder xPathExpression = new StringBuilder();
        String path = emfPath;
        path = path.replaceAll("@", "");
        path = path.replaceAll("//", "/core:Model/");
        Pattern pattern = Pattern.compile("([^\\.]*)\\.(\\d+)([^/]*)");
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group(2));
            xPathExpression.append(matcher.group(1));
            xPathExpression.append('[');
            xPathExpression.append(++index);
            xPathExpression.append(']');
        }
        return xPathExpression;
    }

    private static String applyPatternVar(String condition) {
        Pattern pattern = patternVar;
        Matcher matcher = pattern.matcher(condition);
        while (matcher.matches()) {
            condition = String.valueOf(matcher.group(1)) + matcher.group(2) + matcher.group(3);
            matcher = pattern.matcher(condition);
        }
        return condition;
    }

    private static String applyPatternsOp(String condition) {
        condition = CustomXslFunctions.applyPatternEqual(condition);
        condition = CustomXslFunctions.applyPatternDifferent(condition);
        return condition;
    }

    private static String applyPatternEqual(String condition) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = patternEqual;
        Matcher matcher = pattern.matcher(condition);
        if (matcher.matches()) {
            result.append(matcher.group(1));
            result.append(".toString().equals(\"");
            result.append(matcher.group(2));
            result.append("\")");
            result.append(matcher.group(3));
            result.append(CustomXslFunctions.applyPatternsOp(matcher.group(4)));
        } else {
            result.append(condition);
        }
        return result.toString();
    }

    private static String applyPatternDifferent(String condition) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = patternDifferent;
        Matcher matcher = pattern.matcher(condition);
        if (matcher.matches()) {
            result.append("!");
            result.append(matcher.group(1));
            result.append(".toString().equals(\"");
            result.append(matcher.group(2));
            result.append("\")");
            result.append(matcher.group(3));
            result.append(CustomXslFunctions.applyPatternsOp(matcher.group(4)));
        } else {
            result.append(condition);
        }
        return result.toString();
    }

    public static String getCondition(String jwtCondition, Node guard, Node root) {
        String condition = jwtCondition;
        condition = condition.replaceAll("&amp;", "&");
        condition = CustomXslFunctions.applyPatternVar(condition);
        condition = CustomXslFunctions.applyPatternsOp(condition);
        return condition;
    }

    public static String createStringFromNode(Node node) throws TransformerException {
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        TransformerFactory tFactory = TransformerFactoryImpl.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(node);
        transformer.transform(source, resultStream);
        return out.toString();
    }

    public static String createStringFromNodeList(NodeList nodes) throws TransformerException {
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            DOMSource source = new DOMSource(node);
            transformer.transform(source, resultStream);
            ++i;
        }
        return out.toString();
    }

    public static String getUpperCaseValueFromPath(Node nodePath, Node root) throws Exception {
        return CustomXslFunctions.getValueFromPath(nodePath, root).toUpperCase();
    }

    public static String getUpperCaseValueFromPath(Node nodePath, Node root, String attribute) throws Exception {
        return CustomXslFunctions.getValueFromPath(nodePath, root, attribute).toUpperCase();
    }

    public static String getPropertyValue(String propName) {
        return PROPERTIES.get().getProperty(propName);
    }
}

