/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jwt.meta.PluginProperties;
import org.eclipse.jwt.meta.model.core.NamedElement;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.ActivityNode;

public class CommandHelper {
    public static EObject getRoot(EObject object) {
        EObject parent = object;
        while (parent.eContainer() != null) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static String collectNames(Set elements) {
        String nameString = "";
        for (EObject element : elements) {
            if (!(element instanceof NamedElement)) continue;
            String name = ((NamedElement)element).getName();
            if (name == null || name.equals("")) {
                name = PluginProperties.model_Unnamed_name;
            }
            nameString = String.valueOf(nameString) + "'" + PluginProperties.model_type(element) + ": " + name + "'  ";
        }
        if (nameString != null && nameString.length() > 3) {
            nameString = nameString.substring(0, nameString.length() - 2);
        }
        return nameString;
    }

    public static Set collectReferencedElements(Set relevantElements, EObject root, boolean returnReferences) {
        HashSet<EObject> result = new HashSet<EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            Activity activity;
            EObject eobject = (EObject)iter.next();
            if (!(eobject instanceof ActivityLinkNode) || !relevantElements.contains(activity = ((ActivityLinkNode)eobject).getLinksto())) continue;
            if (returnReferences) {
                result.add(eobject);
                continue;
            }
            result.add(activity);
        }
        return result;
    }

    public static Set collectRelevantElements(EObject rootObject) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (rootObject instanceof Activity) {
            result.add(rootObject);
        } else if (rootObject instanceof ReferenceableElement) {
            result.add(rootObject);
        }
        TreeIterator iter = rootObject.eAllContents();
        while (iter.hasNext()) {
            EObject eobject = (EObject)iter.next();
            if (eobject instanceof Activity) {
                result.add(eobject);
                continue;
            }
            if (!(eobject instanceof ReferenceableElement)) continue;
            result.add(eobject);
        }
        return result;
    }

    public static Set getAffectedEdges(Collection affectedObjects) {
        HashSet<ActivityEdge> affectedEdges = new HashSet<ActivityEdge>();
        for (EObject object : affectedObjects) {
            if (!(object instanceof ActivityNode)) continue;
            ActivityNode activityNode = (ActivityNode)object;
            for (ActivityEdge actEdge : activityNode.getIn()) {
                if (!affectedObjects.contains(actEdge.getSource())) continue;
                affectedEdges.add(actEdge);
            }
            for (ActivityEdge actEdge : activityNode.getOut()) {
                if (!affectedObjects.contains(actEdge.getTarget())) continue;
                affectedEdges.add(actEdge);
            }
        }
        return affectedEdges;
    }
}

