/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.context.ISaveImageContext;
import org.eclipse.graphiti.features.impl.AbstractSaveImageFeature;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ui.print.ExportDiagramDialog;
import org.eclipse.graphiti.ui.internal.util.ui.print.IDiagramsExporter;
import org.eclipse.graphiti.ui.saveasimage.ISaveAsImageConfiguration;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DefaultSaveImageFeature
extends AbstractSaveImageFeature
implements ISaveImageFeature {
    public DefaultSaveImageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void save(ISaveImageContext context) {
        String filename;
        GraphicalViewer viewer = this.getGraphicalViewer(context);
        ISaveAsImageConfiguration saveAsImageConfiguration = this.getSaveAsImageConfiguration(viewer);
        if (saveAsImageConfiguration.configure() == 0 && (filename = this.getFilename(viewer, saveAsImageConfiguration)) != null) {
            Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
            try {
                filename = this.addFileExtension(saveAsImageConfiguration.getFormattedFileExtension(), filename);
                IRunnableWithProgress operation = this.getSaveAsImageOperation(saveAsImageConfiguration, filename);
                new ProgressMonitorDialog(shell).run(false, false, operation);
            }
            catch (InterruptedException interruptedException) {
                T.racer().warning("Save as image operation was cancelled by user");
            }
            catch (Exception e) {
                String message = "Cannot save image: ";
                MessageDialog.openError((Shell)shell, (String)"Cannot save image", (String)(String.valueOf(message) + e.getMessage()));
                T.racer().error(message, (Throwable)e);
            }
        }
    }

    protected GraphicalViewer getGraphicalViewer(ISaveImageContext context) {
        IDiagramContainer diagramContainer = this.getDiagramBehavior().getDiagramContainer();
        if (diagramContainer instanceof IAdaptable) {
            return (GraphicalViewer)((IAdaptable)diagramContainer).getAdapter(GraphicalViewer.class);
        }
        return null;
    }

    protected ISaveAsImageConfiguration getSaveAsImageConfiguration(GraphicalViewer viewer) {
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        ExportDiagramDialog saveAsImageDialog = new ExportDiagramDialog(shell, viewer);
        saveAsImageDialog.addExporters(this.getDiagramExporters());
        return saveAsImageDialog;
    }

    protected String getFilename(GraphicalViewer viewer, ISaveAsImageConfiguration saveAsImageConfiguration) {
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        String[] fileExtensions = new String[]{"*." + saveAsImageConfiguration.getFormattedFileExtension()};
        fileDialog.setFilterExtensions(fileExtensions);
        String name = ((Diagram)viewer.getContents().getModel()).getName();
        fileDialog.setFileName(name);
        String filename = fileDialog.open();
        return filename;
    }

    protected String addFileExtension(String extension, String filename) {
        Path path = new Path(filename);
        if (path.getFileExtension() == null) {
            filename = String.valueOf(filename) + "." + extension;
        }
        return filename;
    }

    protected IRunnableWithProgress getSaveAsImageOperation(ISaveAsImageConfiguration saveAsImageConfiguration, String filename) {
        IRunnableWithProgress operation = null;
        String imageExtension = saveAsImageConfiguration.getFileExtension();
        operation = this.getDiagramExporters().containsKey(imageExtension) ? this.getSaveAsImageOperationForNonStandardExporter(saveAsImageConfiguration, filename) : this.getSaveAsImageOperationForStandardExporter(saveAsImageConfiguration, filename);
        return operation;
    }

    protected IRunnableWithProgress getSaveAsImageOperationForNonStandardExporter(final ISaveAsImageConfiguration saveAsImageConfiguration, final String filename) {
        String imageExtension = saveAsImageConfiguration.getFileExtension();
        final IDiagramsExporter exporter = ExtensionManager.getSingleton().getDiagramExporterForType(imageExtension);
        Assert.isNotNull((Object)exporter);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    exporter.export(saveAsImageConfiguration.getScaledImage(), saveAsImageConfiguration.getFigure(), filename, saveAsImageConfiguration.getImageScaleFactor());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        return operation;
    }

    protected IRunnableWithProgress getSaveAsImageOperationForStandardExporter(ISaveAsImageConfiguration saveAsImageConfiguration, final String filename) {
        int imageFormat = saveAsImageConfiguration.getImageFormat();
        final byte[] imageBytes = GraphitiUi.getImageService().convertImageToBytes(saveAsImageConfiguration.getScaledImage(), imageFormat);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                FileOutputStream outputStream = null;
                try {
                    try {
                        outputStream = new FileOutputStream(filename);
                        outputStream.write(imageBytes);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception x) {
                        T.racer().error("close output stream failed", (Throwable)x);
                    }
                }
            }
        };
        return operation;
    }

    protected Map<String, Boolean> getDiagramExporters() {
        Map<String, Boolean> diagramExporterTypes = ExtensionManager.getSingleton().getDiagramExporterTypes();
        return diagramExporterTypes;
    }
}

