/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnStrokeHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnTypeHandler;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class TypeStrokeGesture
extends AbstractGesture {
    public static final Class<IOnTypeHandler> ON_TYPE_POLICY_KEY = IOnTypeHandler.class;
    public static final Class<IOnStrokeHandler> ON_STROKE_POLICY_KEY = IOnStrokeHandler.class;
    private Map<Scene, EventHandler<? super KeyEvent>> pressedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> releasedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> typedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new IdentityHashMap<IViewer, ChangeListener<Boolean>>();
    private IViewer activeViewer;

    @Override
    protected void doActivate() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            FocusModel focusModel = (FocusModel)((Object)viewer.getAdapter(FocusModel.class));
            if (focusModel == null) {
                throw new IllegalStateException("Cannot find FocusModel.");
            }
            final HashSet pressedKeys = new HashSet();
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (TypeStrokeGesture.this.activeViewer == null) {
                        return;
                    }
                    for (IViewer iViewer : TypeStrokeGesture.this.getDomain().getViewers().values()) {
                        if (!iViewer.isViewerFocused()) continue;
                        return;
                    }
                    for (IOnStrokeHandler iOnStrokeHandler : TypeStrokeGesture.this.getActiveHandlers(TypeStrokeGesture.this.activeViewer)) {
                        iOnStrokeHandler.abortPress();
                    }
                    TypeStrokeGesture.this.clearActiveHandlers(TypeStrokeGesture.this.activeViewer);
                    TypeStrokeGesture.this.activeViewer = null;
                    TypeStrokeGesture.this.getDomain().closeExecutionTransaction(TypeStrokeGesture.this);
                    pressedKeys.clear();
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getRootPart().getVisual().getScene();
            if (this.pressedFilterMap.containsKey(scene)) continue;
            EventHandler<KeyEvent> pressedFilter = new EventHandler<KeyEvent>(){

                /*
                 * WARNING - void declaration
                 */
                public void handle(KeyEvent event) {
                    boolean isInitialPress = false;
                    if (pressedKeys.isEmpty()) {
                        void var3_6;
                        Object var3_3 = null;
                        EventTarget target = event.getTarget();
                        if (target instanceof Node) {
                            Node node = (Node)target;
                            TypeStrokeGesture.this.activeViewer = PartUtils.retrieveViewer(TypeStrokeGesture.this.getDomain(), node);
                        } else if (target instanceof Scene) {
                            for (IViewer v : TypeStrokeGesture.this.getDomain().getViewers().values()) {
                                if (v.getRootPart().getVisual().getScene() != target || !v.isViewerFocused()) continue;
                                TypeStrokeGesture.this.activeViewer = v;
                                break;
                            }
                            if (TypeStrokeGesture.this.activeViewer != null) {
                                Object v = TypeStrokeGesture.this.activeViewer.getRootPart().getVisual();
                            }
                        } else {
                            throw new IllegalStateException("Unsupported event target: " + target);
                        }
                        if (TypeStrokeGesture.this.activeViewer == null) {
                            return;
                        }
                        TypeStrokeGesture.this.getDomain().openExecutionTransaction(TypeStrokeGesture.this);
                        isInitialPress = true;
                        TypeStrokeGesture.this.setActiveHandlers(TypeStrokeGesture.this.activeViewer, TypeStrokeGesture.this.getHandlerResolver().resolve(TypeStrokeGesture.this, (Node)var3_6, TypeStrokeGesture.this.activeViewer, ON_STROKE_POLICY_KEY));
                    }
                    pressedKeys.add(event.getCode());
                    for (IOnStrokeHandler iOnStrokeHandler : TypeStrokeGesture.this.getActiveHandlers(TypeStrokeGesture.this.activeViewer)) {
                        if (isInitialPress) {
                            iOnStrokeHandler.initialPress(event);
                            continue;
                        }
                        iOnStrokeHandler.press(event);
                    }
                }
            };
            this.pressedFilterMap.put(scene, (EventHandler<? super KeyEvent>)pressedFilter);
            EventHandler<KeyEvent> releasedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    boolean isFinalRelease = pressedKeys.size() == 1 && pressedKeys.contains(event.getCode());
                    for (IOnStrokeHandler iOnStrokeHandler : TypeStrokeGesture.this.getActiveHandlers(TypeStrokeGesture.this.activeViewer)) {
                        if (isFinalRelease) {
                            iOnStrokeHandler.finalRelease(event);
                            continue;
                        }
                        iOnStrokeHandler.release(event);
                    }
                    if (isFinalRelease) {
                        TypeStrokeGesture.this.clearActiveHandlers(TypeStrokeGesture.this.activeViewer);
                        TypeStrokeGesture.this.activeViewer = null;
                        TypeStrokeGesture.this.getDomain().closeExecutionTransaction(TypeStrokeGesture.this);
                    }
                    pressedKeys.remove(event.getCode());
                }
            };
            this.releasedFilterMap.put(scene, (EventHandler<? super KeyEvent>)releasedFilter);
            EventHandler<KeyEvent> typedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (pressedKeys.isEmpty()) {
                        TypeStrokeGesture.this.getDomain().openExecutionTransaction(TypeStrokeGesture.this);
                    }
                    EventTarget target = event.getTarget();
                    Object targetNode = null;
                    if (target instanceof Node) {
                        targetNode = (Node)target;
                    } else if (target instanceof Scene) {
                        for (IViewer v : TypeStrokeGesture.this.getDomain().getViewers().values()) {
                            if (v.getRootPart().getVisual().getScene() != target || !v.isViewerFocused()) continue;
                            targetNode = v.getRootPart().getVisual();
                            break;
                        }
                    } else {
                        throw new IllegalStateException("Unsupported event target: " + target);
                    }
                    IViewer targetViewer = PartUtils.retrieveViewer(TypeStrokeGesture.this.getDomain(), targetNode);
                    if (targetViewer != null) {
                        List<IOnTypeHandler> policies = TypeStrokeGesture.this.getHandlerResolver().resolve(TypeStrokeGesture.this, (Node)targetNode, targetViewer, ON_TYPE_POLICY_KEY);
                        for (IOnTypeHandler policy : policies) {
                            policy.type(event, pressedKeys);
                        }
                    }
                    if (pressedKeys.isEmpty()) {
                        TypeStrokeGesture.this.getDomain().closeExecutionTransaction(TypeStrokeGesture.this);
                    }
                }
            };
            this.typedFilterMap.put(scene, (EventHandler<? super KeyEvent>)typedFilter);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)pressedFilter);
            scene.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)releasedFilter);
            scene.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)typedFilter);
        }
    }

    @Override
    protected void doDeactivate() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
            Scene scene = viewer.getRootPart().getVisual().getScene();
            if (this.pressedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.pressedFilterMap.remove(scene));
            }
            if (this.releasedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_RELEASED, this.releasedFilterMap.remove(scene));
            }
            if (!this.typedFilterMap.containsKey(scene)) continue;
            scene.removeEventFilter(KeyEvent.KEY_TYPED, this.typedFilterMap.remove(scene));
        }
    }

    public List<? extends IOnStrokeHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }
}

