/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.doubleclicking;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class DotHtmlLabelDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    protected IRegion findWord(IDocument document, int offset) {
        ITypedRegion region = null;
        try {
            region = document.getPartition(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        int htmlLabelStartOffset = region.getOffset() + 1;
        int htmlLabelLength = region.getLength() - 2;
        String htmlLabel = null;
        try {
            htmlLabel = document.get(htmlLabelStartOffset, htmlLabelLength);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        Injector injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
        IXtextDocument htmlDocument = null;
        try {
            htmlDocument = DotEditorUtils.getDocument(injector, htmlLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int htmlLabelClickOffset = offset - htmlLabelStartOffset;
        ITextDoubleClickStrategy doubleClickStrategy = null;
        try {
            doubleClickStrategy = ((DoubleClickStrategyProvider)injector.getInstance(DoubleClickStrategyProvider.class)).getStrategy(null, htmlDocument.getContentType(htmlLabelClickOffset), "__dftl_partitioning");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        IRegion htmlRegion = this.findRegionHtml((IDocument)htmlDocument, htmlLabelClickOffset, doubleClickStrategy);
        return new Region(htmlLabelStartOffset + htmlRegion.getOffset(), htmlRegion.getLength());
    }

    private IRegion findRegionHtml(IDocument htmlDocument, int htmlLabelClickOffset, ITextDoubleClickStrategy doubleClickStrategy) {
        IRegion htmlRegion = this.findExtendedSelectionHtml(doubleClickStrategy, htmlDocument, htmlLabelClickOffset);
        if (htmlRegion != null) {
            return htmlRegion;
        }
        return this.findWordHtml(doubleClickStrategy, htmlDocument, htmlLabelClickOffset);
    }

    private IRegion findExtendedSelectionHtml(ITextDoubleClickStrategy doubleClickStrategy, IDocument htmlDocument, int htmlLabelClickOffset) {
        Method findExtendedSelection = this.findExtendedDoubleClickSelectionMethod(doubleClickStrategy.getClass());
        return this.invokeMethodOn(findExtendedSelection, doubleClickStrategy, htmlDocument, htmlLabelClickOffset);
    }

    private IRegion findWordHtml(ITextDoubleClickStrategy doubleClickStrategy, IDocument htmlDocument, int htmlLabelClickOffset) {
        Method findWord = this.findWordMethod(doubleClickStrategy.getClass());
        return this.invokeMethodOn(findWord, doubleClickStrategy, htmlDocument, htmlLabelClickOffset);
    }

    private Method findWordMethod(Class<?> strategyClass) {
        return this.methodByName("findWord", strategyClass);
    }

    private Method findExtendedDoubleClickSelectionMethod(Class<?> strategyClass) {
        return this.methodByName("findExtendedDoubleClickSelection", strategyClass);
    }

    private Method methodByName(String name, Class<?> strategyClass) {
        Method method;
        try {
            method = strategyClass.getDeclaredMethod(name, IDocument.class, Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Class<?> superClass = strategyClass.getSuperclass();
            if (superClass != null) {
                return this.methodByName(name, strategyClass.getSuperclass());
            }
            return null;
        }
        method.setAccessible(true);
        return method;
    }

    private IRegion invokeMethodOn(Method method, ITextDoubleClickStrategy doubleClickStrategy, IDocument htmlDocument, int htmlLabelClickOffset) {
        IRegion htmlRegion = null;
        try {
            htmlRegion = (IRegion)method.invoke((Object)doubleClickStrategy, htmlDocument, htmlLabelClickOffset);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return htmlRegion;
    }
}

