/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.WiringErrorAnalyzer;
import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.IThrowable;
import org.eclipse.epp.logging.aeri.core.util.ModelSwitch;
import org.eclipse.epp.logging.aeri.core.util.Reports;

public class WiringErrorAnalyzerProcessor
implements IReportProcessor {
    private IProcessorDescriptor descriptor;

    @Inject
    public WiringErrorAnalyzerProcessor(IProcessorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean canContribute(IStatus status, IEclipseContext context) {
        ContainsRequiredExceptionSwitch containsException = new ContainsRequiredExceptionSwitch();
        Reports.visit((EObject)Reports.newReport((IStatus)status), (ModelSwitch)containsException);
        return containsException.isContained;
    }

    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return this.canContribute(status, context);
    }

    public void process(final IReport report, IStatus status, IEclipseContext context) {
        String comment = (String)context.get(this.getContextKey());
        if (comment == null) {
            final StringBuilder b = new StringBuilder();
            ModelSwitch<Void> visitor = new ModelSwitch<Void>(){

                public Void caseThrowable(IThrowable throwable) {
                    Optional<String> bundleComment = new WiringErrorAnalyzer().computeComment((List<IBundle>)report.getPresentBundles(), throwable);
                    if (bundleComment.isPresent()) {
                        b.append((String)bundleComment.get());
                    }
                    return null;
                }
            };
            Reports.visit((EObject)report, (ModelSwitch)visitor);
            comment = b.toString();
            context.set(this.getContextKey(), (Object)comment);
        }
        if (!comment.isEmpty()) {
            report.getAuxiliaryInformation().put((Object)this.descriptor.getDirective(), (Object)comment);
        }
    }

    protected String getContextKey() {
        return "processor." + this.descriptor.getDirective() + ".value";
    }

    private final class ContainsRequiredExceptionSwitch
    extends ModelSwitch<Void> {
        boolean isContained = false;
        private Set<String> possibleExceptions = Sets.newHashSet((Object[])new String[]{NoClassDefFoundError.class.getName(), LinkageError.class.getName(), ClassNotFoundException.class.getName(), NoSuchMethodError.class.getName(), VerifyError.class.getName()});

        private ContainsRequiredExceptionSwitch() {
        }

        public Void caseThrowable(IThrowable throwable) {
            String className = throwable.getClassName();
            if (this.possibleExceptions.contains(className)) {
                this.isContained = true;
            }
            return null;
        }
    }
}

