/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import org.eclipse.cdt.internal.ui.cview.CopyAction;
import org.eclipse.cdt.internal.ui.cview.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.ide.ResourceSelectionUtil;

public class CNavigatorEditActionGroup
extends ActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private TextActionHandler textActionHandler;
    private Shell shell;

    public CNavigatorEditActionGroup(Shell aShell) {
        this.shell = aShell;
        this.makeActions();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        this.copyAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.copyAction);
        this.pasteAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.textActionHandler == null) {
            this.textActionHandler = new TextActionHandler(actionBars);
        }
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    protected void makeActions() {
        SameShellProvider shellProvider = new SameShellProvider((Control)this.shell);
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.pasteAction = new PasteAction(this.shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new CopyAction(this.shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.deleteAction = new DeleteResourceAction((IShellProvider)shellProvider);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
    }
}

