/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.CoreException;

public class EvalNaryTypeId
extends CPPDependentEvaluation {
    private final ICPPASTNaryTypeIdExpression.Operator fOperator;
    private final IType[] fOperands;
    private boolean fCheckedValueDependent;
    private boolean fIsValueDependent;

    public EvalNaryTypeId(ICPPASTNaryTypeIdExpression.Operator operator, IType[] operands, IASTNode pointOfDefinition) {
        this(operator, operands, EvalNaryTypeId.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalNaryTypeId(ICPPASTNaryTypeIdExpression.Operator operator, IType[] operands, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fOperands = operands;
    }

    public ICPPASTNaryTypeIdExpression.Operator getOperator() {
        return this.fOperator;
    }

    public IType[] getOperands() {
        return this.fOperands;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return false;
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedValueDependent) {
            IType[] iTypeArray = this.fOperands;
            int n = this.fOperands.length;
            int n2 = 0;
            while (n2 < n) {
                IType operand = iTypeArray[n2];
                if (CPPTemplates.isDependentType(operand)) {
                    this.fIsValueDependent = true;
                }
                ++n2;
            }
            this.fCheckedValueDependent = true;
        }
        return this.fIsValueDependent;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalNaryTypeId)) {
            return false;
        }
        EvalNaryTypeId o = (EvalNaryTypeId)other;
        return this.fOperator == o.fOperator && EvalNaryTypeId.areEquivalentTypes(this.fOperands, o.fOperands);
    }

    @Override
    public IType getType() {
        switch (this.fOperator) {
            case __is_trivially_constructible: 
            case __is_constructible: {
                return CPPBasicType.BOOLEAN;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        return ValueFactory.evaluateNaryTypeIdExpression(this.fOperator, this.fOperands, this.getTemplateDefinition());
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IType[] operands = CPPTemplates.instantiateTypes(this.fOperands, context);
        if (operands == this.fOperands) {
            return this;
        }
        return new EvalNaryTypeId(this.fOperator, operands, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int result = 0;
        int i = 0;
        while (i < this.fOperands.length) {
            result = CPPTemplates.combinePackSize(result, CPPTemplates.determinePackSize(this.fOperands[i], tpMap));
            ++i;
        }
        return result;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.isValueDependent();
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)21);
        buffer.putByte((byte)this.fOperator.ordinal());
        buffer.putInt(this.fOperands.length);
        IType[] iTypeArray = this.fOperands;
        int n = this.fOperands.length;
        int n2 = 0;
        while (n2 < n) {
            IType operand = iTypeArray[n2];
            buffer.marshalType(operand);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        int len = buffer.getInt();
        IType[] operands = new IType[len];
        int i = 0;
        while (i < len) {
            operands[i] = buffer.unmarshalType();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalNaryTypeId(ICPPASTNaryTypeIdExpression.Operator.values()[op], operands, templateDefinition);
    }
}

