/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.core.DesignElement;

public class AbstractSemanticValidator {
    private static final String MODULE_DESIGN = "design";
    private static final String MODULE_LIBRARY = "library";
    protected String name = null;
    protected String[] modules = new String[2];

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        assert (name != null);
        this.name = name;
    }

    public void setModules(String moduleNames) {
        String[] splittedModuleNames = moduleNames.split(",");
        assert (splittedModuleNames.length <= 2);
        int i = 0;
        while (i < splittedModuleNames.length) {
            this.modules[i] = splittedModuleNames[i].trim();
            ++i;
        }
    }

    public boolean canApplyToDesign() {
        return this.canApplyToModule(MODULE_DESIGN);
    }

    public boolean canApplyToLibrary() {
        return this.canApplyToModule(MODULE_LIBRARY);
    }

    private boolean canApplyToModule(String moduleName) {
        assert (moduleName == MODULE_DESIGN || moduleName == MODULE_LIBRARY);
        int i = 0;
        while (i < this.modules.length) {
            if (moduleName.equals(this.modules[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isInTemplateParameterDefinitionSlot(DesignElement element) {
        if (element == null) {
            return false;
        }
        return element.isInTemplateParameterDefinitionSlot();
    }
}

