/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResultSetColumnPage
extends Composite {
    String[] displayDataTypes;
    protected static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    protected static String COLUMN_NAME = Messages.getString((String)"dataset.editor.title.name");
    protected static String COLUMN_DATA_TYPE = Messages.getString((String)"dataset.editor.title.type");
    protected static String COLUMN_ALIAS = Messages.getString((String)"dataset.editor.title.alias");
    protected static String COLUMN_DISPLAY_NAME = Messages.getString((String)"dataset.editor.title.displayName");
    protected static String COLUMN_DISPLAY_NAME_KEY = Messages.getString((String)"dataset.editor.title.displayNameKey");
    protected ArrayList<ResultSetColumnModel> columnList = new ArrayList();
    protected ArrayList listenerList = new ArrayList();
    protected IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }
    };
    protected ITableLabelProvider labelProvider;
    protected TableViewer columnTable;
    private Button add;
    private Button edit;
    private Button up;
    private Button down;
    private Button delete;

    private static int getTypeIndex(String typeName) {
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].getName().equals(typeName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public ResultSetColumnPage(Composite parent, int style) {
        super(parent, style);
        this.initPageInfos();
        this.initLabelProvider();
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 650;
        this.setLayoutData(gd);
        this.createTableArea();
        this.createButtonArea();
        this.updateButtons();
        this.initAccessible();
    }

    protected void initLabelProvider() {
        this.labelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ResultSetColumnModel model = (ResultSetColumnModel)element;
                String text = null;
                switch (columnIndex) {
                    case 1: {
                        text = model.columnName;
                        break;
                    }
                    case 2: {
                        if (model.dataType < 0 || model.dataType >= dataTypes.length) break;
                        text = dataTypes[model.dataType].getDisplayName();
                        break;
                    }
                    case 3: {
                        text = model.alias;
                        break;
                    }
                    case 4: {
                        text = model.displayName;
                        break;
                    }
                    case 5: {
                        text = model.displayNameKey;
                    }
                }
                return Utility.convertToGUIString(text);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private void initPageInfos() {
        this.displayDataTypes = new String[dataTypes.length];
        int i = 0;
        while (i < this.displayDataTypes.length) {
            this.displayDataTypes[i] = dataTypes[i].getDisplayName();
            ++i;
        }
    }

    protected void createTableArea() {
        Table table = new Table((Composite)this, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ResultSetColumnPage.this.buttonPressed(127);
                }
            }
        });
        String[] stringArray = new String[6];
        stringArray[1] = COLUMN_NAME;
        stringArray[2] = COLUMN_DATA_TYPE;
        stringArray[3] = COLUMN_ALIAS;
        stringArray[4] = COLUMN_DISPLAY_NAME;
        stringArray[5] = COLUMN_DISPLAY_NAME_KEY;
        String[] columns = stringArray;
        int[] columnWidth = new int[]{20, 100, 100, 100, 100, 100};
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
            ++i;
        }
        this.columnTable = new TableViewer(table);
        this.columnTable.setColumnProperties(columns);
        this.columnTable.setContentProvider((IContentProvider)this.contentProvider);
        this.columnTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.columnTable.setInput(this.columnList);
        this.columnTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultSetColumnPage.this.updateButtons();
            }
        });
        this.columnTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.updateButtons();
            }
        });
        this.columnTable.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ResultSetColumnPage.this.columnTable.getTable().getSelectionCount() == 1) {
                    ResultSetColumnPage.this.doEdit();
                }
            }
        });
    }

    private void createButtonArea() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4));
        GridLayout layout = Utility.createGridLayoutWithoutMargin();
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.add = new Button(composite, 0);
        this.add.setText(Messages.getString((String)"ResultSetColumnPage.button.add"));
        this.add.setEnabled(true);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.doNew();
            }
        });
        this.edit = new Button(composite, 0);
        this.edit.setText(Messages.getString((String)"ResultSetColumnPage.button.edit"));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.doEdit();
            }
        });
        this.delete = new Button(composite, 0);
        this.delete.setText(Messages.getString((String)"ResultSetColumnPage.button.delete"));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(127);
            }
        });
        this.up = new Button(composite, 0);
        this.up.setText(Messages.getString((String)"ResultSetColumnPage.button.up"));
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(128);
            }
        });
        this.down = new Button(composite, 0);
        this.down.setText(Messages.getString((String)"ResultSetColumnPage.button.down"));
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(1024);
            }
        });
        int width = this.getMaxWidth((Control)this.add, 55);
        width = this.getMaxWidth((Control)this.edit, width);
        width = this.getMaxWidth((Control)this.delete, width);
        width = this.getMaxWidth((Control)this.up, width);
        width = this.getMaxWidth((Control)this.down, width);
        GridData buttonGd = new GridData();
        buttonGd.widthHint = width;
        this.add.setLayoutData((Object)buttonGd);
        this.edit.setLayoutData((Object)buttonGd);
        this.delete.setLayoutData((Object)buttonGd);
        this.up.setLayoutData((Object)buttonGd);
        this.down.setLayoutData((Object)buttonGd);
    }

    private int getMaxWidth(Control control, int size) {
        int width = control.computeSize((int)-1, (int)-1).x;
        return width > size ? width : size;
    }

    protected void doNew() {
        ColumnInputDialog inputDialog = new ColumnInputDialog(this.getShell(), Messages.getString((String)"ResultSetColumnPage.inputDialog.newColumn.title"), new ResultSetColumnModel());
        if (inputDialog.open() == 0) {
            ResultSetColumnModel columnModel = inputDialog.getResultSetColumnModel();
            this.columnList.add(columnModel);
            this.columnTable.refresh();
        }
        this.updateButtons();
    }

    protected void doEdit() {
        ColumnInputDialog inputDialog = new ColumnInputDialog(this.getShell(), Messages.getString((String)"ResultSetColumnPage.inputDialog.editColumn.title"), this.getSelectedColumn());
        if (inputDialog.open() == 0) {
            inputDialog.getResultSetColumnModel();
            this.columnTable.refresh();
        }
        this.updateButtons();
    }

    protected void buttonPressed(int buttonId) {
        ResultSetColumnModel model = this.getSelectedColumn();
        int index = this.columnList.indexOf(model);
        this.columnList.remove(index);
        switch (buttonId) {
            case 128: {
                this.columnList.add(index - 1, model);
                break;
            }
            case 1024: {
                this.columnList.add(index + 1, model);
            }
        }
        this.updateTable();
        this.updateButtons();
    }

    public void saveResult(DataSetHandle handle) {
        PropertyHandle resultSetPropertyHandle = handle.getPropertyHandle("resultSetHints");
        PropertyHandle columnHintPropertyHandle = handle.getPropertyHandle("columnHints");
        try {
            resultSetPropertyHandle.setStringValue(null);
            ArrayList<ColumnHintHandle> removeList = new ArrayList<ColumnHintHandle>();
            for (ColumnHintHandle columnHintHandle : columnHintPropertyHandle) {
                if (this.isDuplicatedName(null, columnHintHandle.getColumnName())) continue;
                removeList.add(columnHintHandle);
            }
            columnHintPropertyHandle.removeItems(removeList);
            Iterator<ResultSetColumnModel> iter = this.columnList.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ResultSetColumnModel model = iter.next();
                ResultSetColumn column = StructureFactory.createResultSetColumn();
                column.setColumnName(model.columnName);
                column.setDataType(dataTypes[model.dataType].getName());
                column.setPosition(Integer.valueOf(i));
                resultSetPropertyHandle.addItem((IStructure)column);
                ColumnHintHandle columnHintHandle2 = null;
                for (ColumnHintHandle columnHintHandle2 : columnHintPropertyHandle) {
                    if (columnHintHandle2.getColumnName().equals(model.columnName)) break;
                    columnHintHandle2 = null;
                }
                if (columnHintHandle2 == null) {
                    ColumnHint columnHint = StructureFactory.createColumnHint();
                    columnHint.setProperty("columnName", (Object)model.columnName);
                    columnHint.setProperty("displayNameID", (Object)model.displayNameKey);
                    columnHintHandle2 = (ColumnHintHandle)columnHintPropertyHandle.addItem((IStructure)columnHint);
                } else {
                    columnHintHandle2.setDisplayName(model.displayName);
                    columnHintHandle2.setDisplayNameKey(model.displayNameKey);
                }
                this.updateColumnHintProperties(model, columnHintHandle2);
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void updateColumnHintProperties(ResultSetColumnModel model, ColumnHintHandle columnHintHandle) throws SemanticException {
        columnHintHandle.setAnalysis(model.analysisType);
        columnHintHandle.setAlias(model.alias);
        columnHintHandle.setDisplayName(model.displayName);
        columnHintHandle.setHelpText(model.helpText);
    }

    public boolean isEmpty() {
        return this.columnList.isEmpty();
    }

    protected boolean isDuplicatedName(ResultSetColumnModel currentModel, String newName) {
        if (newName == null || newName.trim().length() == 0) {
            return false;
        }
        for (ResultSetColumnModel model : this.columnList) {
            if (model == currentModel || !newName.equals(model.columnName) && !newName.equals(model.alias)) continue;
            return true;
        }
        return false;
    }

    protected ResultSetColumnModel getSelectedColumn() {
        return (ResultSetColumnModel)((IStructuredSelection)this.columnTable.getSelection()).getFirstElement();
    }

    public void addTreeRefreshListener(ITreeRefreshListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void updateTable() {
        this.columnTable.refresh();
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            ((ITreeRefreshListener)iter.next()).treeChanged();
        }
    }

    protected void updateButtons() {
        ResultSetColumnModel model;
        int selectedIndex;
        boolean editEnabled = false;
        boolean deleteEnabled = false;
        boolean downEnabled = false;
        boolean upEnabled = false;
        if (!this.columnTable.getSelection().isEmpty() && (selectedIndex = this.columnList.indexOf(model = this.getSelectedColumn())) != -1) {
            upEnabled = selectedIndex != 0;
            downEnabled = selectedIndex != this.columnList.size() - 1;
            deleteEnabled = true;
            editEnabled = true;
        }
        this.up.setEnabled(upEnabled);
        this.down.setEnabled(downEnabled);
        this.delete.setEnabled(deleteEnabled);
        this.edit.setEnabled(editEnabled);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ResultSetColumnPage.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ResultSetColumnPage.this.toControl(new Point(e.x, e.y));
                if (ResultSetColumnPage.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ResultSetColumnPage.this.getBounds();
                Point pt = ResultSetColumnPage.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    static /* synthetic */ int access$0(String string) {
        return ResultSetColumnPage.getTypeIndex(string);
    }

    private class ColumnInputDialog
    extends PropertyHandleInputDialog {
        private String title;
        private ResultSetColumnModel columnModel;
        private String columnName;
        private String alias;
        private String displayName;
        private String displayNameKey;
        private int dataType;
        private String EMPTY_STRING;

        public ColumnInputDialog(Shell shell, String title, ResultSetColumnModel columnModel) {
            super(shell);
            this.EMPTY_STRING = "";
            this.title = title;
            this.columnModel = columnModel;
            this.initColumnInfos();
        }

        @Override
        protected void createCustomControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginTop = 5;
            composite.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            composite.setLayoutData((Object)layoutData);
            this.createDialogContents(composite);
        }

        private void createDialogContents(Composite composite) {
            GridData labelData = new GridData();
            labelData.horizontalSpan = 1;
            GridData textData = new GridData(768);
            textData.horizontalSpan = 2;
            Label columnNameLabel = new Label(composite, 0);
            columnNameLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.columnName"));
            columnNameLabel.setLayoutData((Object)labelData);
            final Text columnNameText = new Text(composite, 2048);
            columnNameText.setLayoutData((Object)textData);
            columnNameText.setText(this.columnName);
            columnNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.columnName = columnNameText.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            Label typeLabel = new Label(composite, 0);
            typeLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.dataType"));
            typeLabel.setLayoutData((Object)labelData);
            final Combo typeCombo = ControlProvider.createCombo(composite, 2056);
            typeCombo.setItems(ResultSetColumnPage.this.displayDataTypes);
            typeCombo.setLayoutData((Object)textData);
            if (this.dataType >= 0 && this.dataType < typeCombo.getItemCount()) {
                typeCombo.setText(typeCombo.getItem(this.dataType));
            }
            typeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnInputDialog.this.dataType = typeCombo.getSelectionIndex();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label aliasLabel = new Label(composite, 0);
            aliasLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.alias"));
            aliasLabel.setLayoutData((Object)labelData);
            final Text aliasText = new Text(composite, 2048);
            aliasText.setLayoutData((Object)textData);
            aliasText.setText(this.alias);
            aliasText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.alias = aliasText.getText().trim();
                    ColumnInputDialog.this.validateSyntax();
                }
            });
            Label displayNameLabel = new Label(composite, 0);
            displayNameLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.displayName"));
            displayNameLabel.setLayoutData((Object)labelData);
            final Text displayNameText = new Text(composite, 2048);
            displayNameText.setLayoutData((Object)textData);
            displayNameText.setText(this.displayName);
            displayNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.displayName = displayNameText.getText().trim();
                }
            });
            this.createDisplayNameKeyArea(composite);
        }

        private void createDisplayNameKeyArea(Composite parent) {
            Label displayNameKeyLabel = new Label(parent, 0);
            displayNameKeyLabel.setText(Messages.getString((String)"ResultSetColumnPage.inputDialog.label.displayNameKey"));
            displayNameKeyLabel.setLayoutData((Object)new GridData());
            final Text tx = ControlProvider.createText(parent, this.displayNameKey);
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnInputDialog.this.displayNameKey = tx.getText().trim();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ResourceEditDialog dlg = new ResourceEditDialog(ColumnInputDialog.this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
                    dlg.setResourceURLs(ColumnInputDialog.this.getResourceURLs());
                    if (dlg.open() == 0) {
                        tx.setText((String)dlg.getResult());
                    }
                }
            };
            Button bt = new Button(parent, 8);
            bt.setText("...");
            bt.addSelectionListener((SelectionListener)listener);
            if (this.getBaseName() == null) {
                bt.setEnabled(false);
            }
        }

        private String[] getBaseNames() {
            List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
            if (resources == null) {
                return null;
            }
            return resources.toArray(new String[0]);
        }

        private URL[] getResourceURLs() {
            String[] baseNames = this.getBaseNames();
            if (baseNames == null) {
                return null;
            }
            URL[] urls = new URL[baseNames.length];
            int i = 0;
            while (i < baseNames.length) {
                urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
                ++i;
            }
            return urls;
        }

        private String getBaseName() {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
        }

        @Override
        protected boolean isResizable() {
            return true;
        }

        protected ResultSetColumnModel getResultSetColumnModel() {
            if (this.columnModel == null) {
                this.columnModel = new ResultSetColumnModel();
            }
            this.columnModel.columnName = this.columnName;
            this.columnModel.dataType = this.dataType;
            this.columnModel.alias = this.alias;
            this.columnModel.displayName = this.displayName;
            this.columnModel.displayNameKey = this.displayNameKey;
            return this.columnModel;
        }

        private void initColumnInfos() {
            if (this.columnModel != null) {
                this.columnName = this.resolveNull(this.columnModel.columnName);
                this.alias = this.resolveNull(this.columnModel.alias);
                this.displayName = this.resolveNull(this.columnModel.displayName);
                this.displayNameKey = this.resolveNull(this.columnModel.displayNameKey);
                this.dataType = this.columnModel.dataType;
            } else {
                this.columnName = this.EMPTY_STRING;
                this.alias = this.EMPTY_STRING;
                this.displayName = this.EMPTY_STRING;
                this.displayNameKey = this.EMPTY_STRING;
                this.dataType = -1;
            }
        }

        private String resolveNull(String value) {
            return value == null ? this.EMPTY_STRING : value.trim();
        }

        @Override
        protected void rollback() {
        }

        @Override
        protected IStatus validateSemantics(Object structureOrHandle) {
            return this.validateSyntax(structureOrHandle);
        }

        @Override
        protected IStatus validateSyntax(Object structureOrHandle) {
            if (this.columnName == null || this.columnName.trim().length() == 0) {
                return this.getMiscStatus(4, Messages.getString((String)"ResultSetColumnPage.inputDialog.warning.emptyColumnName"));
            }
            if (this.columnName.equals(this.alias)) {
                return this.getMiscStatus(4, Messages.getString((String)"ResultSetColumnPage.inputDialog.error.sameValue.columnNameAndAlias"));
            }
            if (ResultSetColumnPage.this.isDuplicatedName(this.columnModel, this.columnName)) {
                return this.getMiscStatus(4, Messages.getFormattedString((String)"ResultSetColumnPage.inputDialog.error.duplicatedColumnName", (Object[])new Object[]{this.columnName}));
            }
            if (ResultSetColumnPage.this.isDuplicatedName(this.columnModel, this.alias)) {
                return this.getMiscStatus(4, Messages.getFormattedString((String)"ResultSetColumnPage.inputDialog.error.duplicatedAlias", (Object[])new Object[]{this.alias}));
            }
            return this.getOKStatus();
        }

        @Override
        protected String getTitle() {
            return this.title;
        }
    }

    public static interface ITreeRefreshListener {
        public void treeChanged();
    }

    protected static class ResultSetColumnModel {
        protected String columnName;
        protected String analysisType;
        protected String analysisCoumn;
        protected boolean isIndexColumn;
        protected boolean removeDuplicatedValue;
        protected String alias;
        protected int dataType = ResultSetColumnPage.access$0("string");
        protected String displayName;
        protected String displayNameKey;
        protected String helpText;

        protected ResultSetColumnModel() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ResultSetColumnModel) {
                ResultSetColumnModel model = (ResultSetColumnModel)obj;
                if (this.columnName == null) {
                    return model.columnName == null;
                }
                return this.columnName.equals(model.columnName);
            }
            return false;
        }

        public int hashCode() {
            return this.columnName.hashCode() * 11 + this.dataType * 17;
        }
    }
}

