/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Import;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11UpdateImportCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.dialogs.ImportSelectionDialog;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IImport;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;
import org.w3c.dom.Element;

public class ImportSection
extends ASDAbstractSection {
    protected Text namespaceText;
    protected Text prefixText;
    protected Text locationText;
    private String oldPrefixValue;
    Button button;
    IEditorPart editorPart;
    static /* synthetic */ Class class$0;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(composite, Messages._UI_LABEL_NAMESPACE);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        namespaceLabel.setLayoutData((Object)data);
        this.namespaceText = this.getWidgetFactory().createText(composite, "");
        this.namespaceText.setEditable(false);
        this.namespaceText.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createLabel(composite, "");
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(composite, Messages._UI_LABEL_PREFIX);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        prefixLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(composite, "");
        this.applyTextListeners((Control)this.prefixText);
        this.prefixText.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createLabel(composite, "");
        CLabel locationLabel = this.getWidgetFactory().createCLabel(composite, Messages._UI_LABEL_LOCATION);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        locationLabel.setLayoutData((Object)data);
        this.locationText = this.getWidgetFactory().createText(composite, "");
        this.locationText.setEditable(false);
        this.locationText.setLayoutData((Object)new GridData(768));
        this.button = this.getWidgetFactory().createButton(composite, "", 8);
        this.button.setImage(WSDLEditorPlugin.getInstance().getImage("icons/browsebutton.gif"));
        this.button.addSelectionListener((SelectionListener)this);
        this.button.setLayoutData((Object)new GridData());
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object obj = this.getModel();
        boolean refreshPrefixText = true;
        boolean refreshLocationText = true;
        boolean refreshNamespaceText = true;
        if (this.prefixText.isFocusControl()) {
            refreshPrefixText = false;
        }
        if (this.locationText.isFocusControl()) {
            refreshLocationText = false;
        }
        if (this.namespaceText.isFocusControl()) {
            refreshNamespaceText = false;
        }
        if (refreshPrefixText) {
            this.prefixText.setText("");
        }
        if (refreshLocationText) {
            this.locationText.setText("");
        }
        if (refreshNamespaceText) {
            this.namespaceText.setText("");
        }
        if (obj instanceof IImport) {
            IImport theImport = (IImport)obj;
            if (refreshLocationText) {
                String locationValue = theImport.getLocation();
                this.locationText.setText(locationValue != null ? locationValue : "");
            }
            String namespaceValue = theImport.getNamespace();
            if (refreshNamespaceText) {
                this.namespaceText.setText(namespaceValue != null ? namespaceValue : "");
            }
            if (refreshPrefixText) {
                String prefix = theImport.getNamespacePrefix();
                this.prefixText.setText(prefix != null ? prefix : "");
            }
        }
        this.oldPrefixValue = this.prefixText.getText();
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        this.setErrorMessage(null);
        if (event.widget == this.prefixText && this.locationText.getText().length() > 0 && this.namespaceText.getText().length() > 0 && this.getModel() instanceof W11Import) {
            String newPrefix = this.prefixText.getText();
            if (this.oldPrefixValue.equals(newPrefix)) {
                return;
            }
            W11Import w11Import = (W11Import)this.getModel();
            Import importObj = (Import)w11Import.getTarget();
            Definition definition = importObj.getEnclosingDefinition();
            Map namespacesMap = definition.getNamespaces();
            if (namespacesMap.containsKey(newPrefix)) {
                this.setErrorMessage(Messages._ERROR_LABEL_PREFIX_EXISTS);
            } else {
                Element definitionElement = definition.getElement();
                definitionElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                definitionElement.setAttribute("xmlns:" + newPrefix, this.namespaceText.getText());
                this.oldPrefixValue = newPrefix;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button && this.getModel() instanceof W11Import) {
            W11Import w11Import = (W11Import)this.getModel();
            Import importObj = (Import)w11Import.getTarget();
            ImportSelectionDialog dialog = new ImportSelectionDialog(WSDLEditorPlugin.getShell(), null, true);
            dialog.create();
            int rc = dialog.open();
            if (rc == 0) {
                String locationURI = dialog.getImportLocation();
                String namespaceURI = dialog.getImportNamespace();
                String prefix = this.prefixText.getText();
                IEditorPart iEditorPart = ASDEditorPlugin.getActiveEditor();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                CommandStack stack = (CommandStack)iEditorPart.getAdapter((Class)clazz);
                W11UpdateImportCommand updateImportCommand = new W11UpdateImportCommand(importObj, locationURI, namespaceURI, prefix);
                stack.execute((Command)updateImportCommand);
                Definition definition = importObj.getEnclosingDefinition();
                String actualPrefix = definition.getPrefix(namespaceURI);
                this.namespaceText.setText(namespaceURI);
                this.locationText.setText(locationURI);
                this.prefixText.setText(actualPrefix);
            }
            this.refresh();
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }
}

