/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.launching.AbstractVMInstallType;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.StandardVM;

public class StandardVMType
extends AbstractVMInstallType {
    public static final String ID_STANDARD_VM_TYPE = "org.eclipse.wst.jsdt.internal.debug.ui.launcher.StandardVMType";
    private String fDefaultRootPath;
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator, "jre" + fgSeparator + "bin" + fgSeparator};

    public static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getName() {
        return LaunchingMessages.StandardVMType_Standard_VM_3;
    }

    @Override
    protected IVMInstall doCreateVMInstall(String id) {
        return new StandardVM(this, id);
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        throw new UnimplementedException();
    }

    @Override
    public File detectInstallLocation() {
        throw new UnimplementedException();
    }

    protected IPath getDefaultSystemLibrary(File javaHome) {
        IPath jreLibPath = new Path(javaHome.getPath()).append("lib").append("rt.jar");
        if (jreLibPath.toFile().isFile()) {
            return jreLibPath;
        }
        return new Path(javaHome.getPath()).append("jre").append("lib").append("rt.jar");
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        while (parent != null) {
            File parentsrc = new File(parent, "src.jar");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("src");
                return new Path(parentsrc.getPath());
            }
            parentsrc = new File(parent, "src.zip");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("");
                return new Path(parentsrc.getPath());
            }
            parent = parent.getParentFile();
        }
        IPath result = this.checkForJ9LibrarySource(libLocation);
        if (result != null) {
            return result;
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    private IPath checkForJ9LibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        String name = libLocation.getName();
        if (name.equalsIgnoreCase("classes.zip")) {
            File source = new File(parent, "source/source.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        if (name.equalsIgnoreCase("locale.zip")) {
            File source = new File(parent, "source/locale-src.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        if (name.equalsIgnoreCase("charconv.zip")) {
            File source = new File(parent, "charconv-src.zip");
            return source.isFile() ? new Path(source.getPath()) : Path.EMPTY;
        }
        return null;
    }

    protected IPath getDefaultPackageRootPath() {
        return new Path(this.getDefaultRootPath());
    }

    @Override
    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        File libFile = new File(installLocation, "system.js");
        Path libPath = new Path(libFile.getAbsolutePath());
        LibraryLocation location = new LibraryLocation((IPath)libPath, null, null);
        return new LibraryLocation[]{location};
    }

    protected List gatherAllLibraries(String[] dirPaths) {
        ArrayList<LibraryLocation> libraries = new ArrayList<LibraryLocation>();
        int i = 0;
        while (i < dirPaths.length) {
            File extDir = new File(dirPaths[i]);
            if (extDir.exists() && extDir.isDirectory()) {
                String[] names = extDir.list();
                int j = 0;
                while (j < names.length) {
                    String suffix;
                    int length;
                    String name = names[j];
                    File jar = new File(extDir, name);
                    if (jar.isFile() && (length = name.length()) > 4 && ((suffix = name.substring(length - 4)).equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".jar"))) {
                        try {
                            Path libPath = new Path(jar.getCanonicalPath());
                            LibraryLocation library = new LibraryLocation((IPath)libPath, (IPath)Path.EMPTY, (IPath)Path.EMPTY, null);
                            libraries.add(library);
                        }
                        catch (IOException e) {
                            Util.log(e, "");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return libraries;
    }

    protected File getDefaultExtensionDirectory(File installLocation) {
        File jre = null;
        jre = installLocation.getName().equalsIgnoreCase("jre") ? installLocation : new File(installLocation, "jre");
        File lib = new File(jre, "lib");
        File ext = new File(lib, "ext");
        return ext;
    }

    protected File getDefaultEndorsedDirectory(File installLocation) {
        File lib = new File(installLocation, "lib");
        File ext = new File(lib, "endorsed");
        return ext;
    }

    protected String getDefaultRootPath() {
        return this.fDefaultRootPath;
    }

    protected void setDefaultRootPath(String defaultRootPath) {
        this.fDefaultRootPath = defaultRootPath;
    }

    @Override
    public IStatus validateInstallLocation(File javaHome) {
        throw new UnimplementedException();
    }

    protected String[] parsePaths(String paths) {
        String path;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int index = paths.indexOf(File.pathSeparatorChar, pos);
        while (index > 0) {
            path = paths.substring(pos, index);
            list.add(path);
            pos = index + 1;
            index = paths.indexOf(File.pathSeparatorChar, pos);
        }
        path = paths.substring(pos);
        if (!path.equals("null")) {
            list.add(path);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void disposeVMInstall(String id) {
        IVMInstall vm = this.findVMInstall(id);
        if (vm != null) {
            throw new UnimplementedException();
        }
        super.disposeVMInstall(id);
    }

    @Override
    public URL getDefaultJavadocLocation(File installLocation) {
        throw new UnimplementedException();
    }
}

