/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoEventOpen;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.AbstractEventProperty;
import org.eclipse.wb.internal.core.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.core.model.property.event.EventsPropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.IListenerMethodProperty;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

public final class EventsProperty
extends AbstractEventProperty {
    public EventsProperty(JavaInfo javaInfo) {
        super(javaInfo, "Events", (PropertyEditor)EventsPropertyEditor.INSTANCE);
        this.setCategory(PropertyCategory.HIDDEN);
        this.installDecoratorListener();
        this.installContextMenuListener();
        this.installDeleteListener();
    }

    private void installDecoratorListener() {
        this.m_javaInfo.addBroadcastListener(new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, Image[] icon) throws Exception {
                IPreferenceStore preferences;
                if (object == EventsProperty.this.m_javaInfo && (preferences = EventsProperty.this.m_javaInfo.getDescription().getToolkit().getPreferences()).getBoolean("property.events.decorateIcon") && EventsProperty.this.isModified()) {
                    Image decorator = DesignerPlugin.getImage((String)"events/decorator.gif");
                    icon[0] = SwtResourceManager.decorateImage((Image)icon[0], (Image)decorator, (int)1);
                }
            }
        });
    }

    private void installContextMenuListener() {
        this.m_javaInfo.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (object == EventsProperty.this.m_javaInfo) {
                    EventsProperty.this.contributeActions(manager, ModelMessages.EventsProperty_menuManagerName);
                }
            }
        });
    }

    private void installDeleteListener() {
        this.m_javaInfo.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (child == EventsProperty.this.m_javaInfo) {
                    AbstractListenerProperty[] abstractListenerPropertyArray = EventsProperty.this.getSubProperties();
                    int n = abstractListenerPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractListenerProperty listenerProperty = abstractListenerPropertyArray[n2];
                        if (listenerProperty.isModified()) {
                            listenerProperty.removeListener();
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public boolean isModified() throws Exception {
        AbstractListenerProperty[] properties;
        AbstractListenerProperty[] abstractListenerPropertyArray = properties = this.getSubProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractListenerProperty property = abstractListenerPropertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AbstractListenerProperty[] getSubProperties() throws Exception {
        return EventsPropertyEditor.INSTANCE.getProperties((Property)this);
    }

    private void contributeActions(IMenuManager manager, String implementTitle) throws Exception {
        AbstractListenerProperty[] listenerProperties;
        MenuManager implementMenuManager = new MenuManager(implementTitle);
        AbstractListenerProperty[] abstractListenerPropertyArray = listenerProperties = this.getSubProperties();
        int n = listenerProperties.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractListenerProperty listenerProperty = abstractListenerPropertyArray[n2];
            listenerProperty.addListenerActions(manager, (IMenuManager)implementMenuManager);
            ++n2;
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.events", (IContributionItem)implementMenuManager);
    }

    public void openStubMethod(String methodPath) throws Exception {
        if (methodPath.equals("wbp:openSource")) {
            JavaInfoUtils.scheduleOpenNode(this.m_javaInfo, this.m_javaInfo.getCreationSupport().getNode());
            return;
        }
        if (methodPath.startsWith("wbp:broadcast")) {
            ((JavaInfoEventOpen)this.m_javaInfo.getBroadcast(JavaInfoEventOpen.class)).invoke(this.m_javaInfo, methodPath);
            return;
        }
        String eventMethodPath = "Events/" + methodPath;
        IListenerMethodProperty property = (IListenerMethodProperty)PropertyUtils.getByPath((ObjectInfo)this.m_javaInfo, (String)eventMethodPath);
        if (property != null) {
            property.openStubMethod();
        }
    }
}

