/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.aggregators;

import java.util.OptionalDouble;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.aggregators.AverageAccumulator;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;

public class LongAverageOperator
implements IMultisetAggregationOperator<Long, AverageAccumulator<Long>, Double> {
    public static final LongAverageOperator INSTANCE = new LongAverageOperator();

    private LongAverageOperator() {
    }

    @Override
    public String getShortDescription() {
        return "avg<Integer> incrementally computes the average of java.lang.Integer values";
    }

    @Override
    public String getName() {
        return "avg<Integer>";
    }

    @Override
    public AverageAccumulator<Long> createNeutral() {
        return new AverageAccumulator<Long>(0L, 0L);
    }

    @Override
    public boolean isNeutral(AverageAccumulator<Long> result) {
        return result.count == 0L;
    }

    @Override
    public AverageAccumulator<Long> update(AverageAccumulator<Long> oldResult, Long updateValue, boolean isInsertion) {
        if (isInsertion) {
            oldResult.value = (Long)oldResult.value + updateValue;
            ++oldResult.count;
        } else {
            oldResult.value = (Long)oldResult.value - updateValue;
            --oldResult.count;
        }
        return oldResult;
    }

    @Override
    public Double getAggregate(AverageAccumulator<Long> result) {
        return result.count == 0L ? null : Double.valueOf((double)((Long)result.value).longValue() / (double)result.count);
    }

    @Override
    public Double aggregateStream(Stream<Long> stream) {
        OptionalDouble averageOpt = stream.mapToLong(Long::longValue).average();
        return averageOpt.isPresent() ? Double.valueOf(averageOpt.getAsDouble()) : null;
    }
}

