/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.properties.MatchParameterPropertyDescriptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class MatcherFiltersPropertySource<MATCH extends IPatternMatch> implements IPropertySource {
  private final QueryResultTreeMatcher<MATCH> matcher;
  
  private final Map<PParameter, IPropertyDescriptor> descriptors = CollectionLiterals.<PParameter, IPropertyDescriptor>newHashMap();
  
  public MatcherFiltersPropertySource(final QueryResultTreeMatcher<MATCH> matcher) {
    this.matcher = matcher;
  }
  
  @Override
  public Object getEditableValue() {
    return this;
  }
  
  @Override
  public String toString() {
    boolean _isFiltered = this.matcher.isFiltered();
    if (_isFiltered) {
      return "Filtered";
    }
    return "No filters specified";
  }
  
  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final List<IPropertyDescriptor> filters = Lists.<IPropertyDescriptor>newArrayList();
    final List<PParameter> parameters = this.matcher.getMatcher().getSpecification().getParameters();
    boolean _isEmpty = this.descriptors.isEmpty();
    if (_isEmpty) {
      final Consumer<PParameter> _function = (PParameter it) -> {
        final MatchParameterPropertyDescriptor property = new MatchParameterPropertyDescriptor(it, this.matcher);
        this.descriptors.put(it, property);
        filters.add(property);
      };
      parameters.forEach(_function);
    } else {
      final Consumer<PParameter> _function_1 = (PParameter it) -> {
        filters.add(this.descriptors.get(it));
      };
      parameters.forEach(_function_1);
    }
    return filters.<IPropertyDescriptor>toArray(new IPropertyDescriptor[0]);
  }
  
  @Override
  public Object getPropertyValue(final Object id) {
    final PParameter param = ((PParameter) id);
    return this.matcher.getFilterMatch().get(param.getName());
  }
  
  @Override
  public boolean isPropertySet(final Object id) {
    final PParameter param = ((PParameter) id);
    Object _get = this.matcher.getFilterMatch().get(param.getName());
    return (_get != null);
  }
  
  @Override
  public void resetPropertyValue(final Object id) {
    final PParameter param = ((PParameter) id);
    this.matcher.getFilterMatch().set(param.getName(), null);
    this.matcher.filterUpdated(this.matcher.getFilterMatch());
  }
  
  @Override
  public void setPropertyValue(final Object id, final Object value) {
    final PParameter param = ((PParameter) id);
    this.matcher.getFilterMatch().set(param.getName(), value);
    this.matcher.filterUpdated(this.matcher.getFilterMatch());
  }
}
