/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import com.google.common.base.Joiner;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public final class TimeGraphStyleUtil {
    private static final char SEPARATOR = '.';
    private static final String PREFIX = "view.";

    private TimeGraphStyleUtil() {
    }

    public static void loadValue(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem) {
        IPreferenceStore store = TimeGraphStyleUtil.getStore();
        String fillColorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.fillColor());
        String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.heightFactor());
        Map<String, Object> styleMap = stateItem.getStyleMap();
        RGB defaultRgb = stateItem.getStateColor();
        String defaultString = store.getDefaultString(fillColorKey);
        if (defaultString.isEmpty()) {
            store.setDefault(fillColorKey, new RGBAColor(defaultRgb.red, defaultRgb.green, defaultRgb.blue, 255).toString());
        }
        String rgbColor = store.getString(fillColorKey);
        if (store.getDefaultFloat(heightFactorKey) == 0.0f) {
            float defaultHeightFactor = TimeGraphStyleUtil.isLink(stateItem) ? 0.1f : 1.0f;
            defaultHeightFactor = ((Float)styleMap.getOrDefault(ITimeEventStyleStrings.heightFactor(), Float.valueOf(defaultHeightFactor))).floatValue();
            store.setDefault(heightFactorKey, defaultHeightFactor);
        }
        float heightFactor = store.getFloat(heightFactorKey);
        RGBAColor rgba = RGBAColor.fromString((String)rgbColor);
        if (rgba != null) {
            styleMap.put(ITimeEventStyleStrings.fillColor(), rgba.toInt());
            styleMap.put(ITimeEventStyleStrings.heightFactor(), Float.valueOf(heightFactor));
        }
    }

    private static boolean isLink(StateItem stateItem) {
        return ITimeEventStyleStrings.linkType().equals(TimeGraphStyleUtil.getItemProperty(stateItem));
    }

    private static @Nullable Object getItemProperty(StateItem stateItem) {
        return stateItem.getStyleMap().get(ITimeEventStyleStrings.itemTypeProperty());
    }

    public static String getPreferenceName(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem, String styleKey) {
        return Joiner.on((char)'.').skipNulls().join((Object)(PREFIX + String.valueOf(presentationProvider.getPreferenceKey())), TimeGraphStyleUtil.getItemProperty(stateItem), new Object[]{stateItem.getStateString(), styleKey});
    }

    public static void loadValues(ITimeGraphPresentationProvider presentationProvider) {
        StateItem[] stateItemArray = presentationProvider.getStateTable();
        int n = stateItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateItem stateItem = stateItemArray[n2];
            TimeGraphStyleUtil.loadValue(presentationProvider, stateItem);
            ++n2;
        }
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

