/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.SelectRootNodeWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SynchronizeTracesHandler
extends AbstractHandler {
    private TreeSelection fSelection = null;
    private static final String CR = System.getProperty("line.separator");
    private TmfExperimentElement fExperiment = null;
    private TmfTraceElement fRootNode = null;
    private String fRootNodeId = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SelectRootNodeWizard wizard;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        this.fSelection = null;
        final ArrayList<TmfTraceElement> tl = new ArrayList<TmfTraceElement>();
        final ArrayList<TmfExperimentElement> uiexperiment = new ArrayList<TmfExperimentElement>();
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement exp = (TmfExperimentElement)element;
                uiexperiment.add(exp);
                for (TmfTraceElement trace : exp.getTraces()) {
                    tl.add(trace);
                }
            }
        }
        if (uiexperiment.size() != 1 || tl.size() < 2) {
            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, Messages.SynchronizeTracesHandler_WrongTraceNumber);
            return null;
        }
        this.fExperiment = (TmfExperimentElement)uiexperiment.get(0);
        this.fRootNode = null;
        this.fRootNodeId = null;
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = workbenchWindow.getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)(wizard = new SelectRootNodeWizard(this.fExperiment)));
        int returnValue = dialog.open();
        if (returnValue == 1) {
            return null;
        }
        this.fRootNode = wizard.getRootNode();
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                traces = new ITmfTrace[tl.size()];
                exp = (TmfExperimentElement)uiexperiment.get(0);
                i = 0;
                while (i < tl.size()) {
                    block7: {
                        traceElement = ((TmfTraceElement)tl.get(i)).getElementUnderTraceFolder();
                        trace = traceElement.instantiateTrace();
                        traceEvent = traceElement.instantiateEvent();
                        if (trace == null) {
                            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_WrongType) + traceElement.getName());
                            j = 0;
                            while (j < i) {
                                traces[j].dispose();
                                ++j;
                            }
                            return;
                        }
                        try {
                            trace.initTrace(traceElement.getResource(), traceElement.getResource().getLocation().toOSString(), traceEvent.getClass());
                            TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)trace);
                            break block7;
                        }
                        catch (TmfTraceException e) {
                            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_InitError) + SynchronizeTracesHandler.access$0() + SynchronizeTracesHandler.access$0() + (Object)e);
                            trace.dispose();
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traces[j].dispose();
                            ++j;
                            continue;
                        }
lbl28:
                        // 1 sources

                        return;
                    }
                    if (traceElement.getElementPath().equals(SynchronizeTracesHandler.access$1(SynchronizeTracesHandler.this).getElementPath())) {
                        SynchronizeTracesHandler.access$2(SynchronizeTracesHandler.this, trace.getHostId());
                    }
                    traces[i] = trace;
                    ++i;
                }
                exp.refreshSupplementaryFolder();
                experiment = new TmfExperiment(ITmfEvent.class, exp.getName(), traces, 5000, (IResource)exp.getResource());
                syncAlgo = experiment.synchronizeTraces(true);
                syncAlgo.setRootNode(SynchronizeTracesHandler.access$3(SynchronizeTracesHandler.this));
                TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)experiment);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<TmfTraceElement> tracesToAdd = new ArrayList<TmfTraceElement>();
                        ArrayList<TmfTraceElement> tracesToRemove = new ArrayList<TmfTraceElement>();
                        for (TmfTraceElement traceel : tl) {
                            boolean traceexists;
                            TmfTraceElement origtrace = traceel.getElementUnderTraceFolder();
                            ITmfTrace expTrace = null;
                            for (ITmfTrace t : experiment.getTraces()) {
                                if (!t.getResource().equals((Object)origtrace.getResource())) continue;
                                expTrace = t;
                                break;
                            }
                            if (expTrace == null || !syncAlgo.isTraceSynced(expTrace.getHostId())) continue;
                            StringBuilder newname = new StringBuilder(traceel.getName());
                            IContainer parentFolder = origtrace.getResource().getParent();
                            do {
                                traceexists = false;
                                newname.append('_');
                                if (parentFolder.findMember(newname.toString()) == null) continue;
                                traceexists = true;
                            } while (traceexists);
                            TmfTraceElement newtrace = origtrace.copy(newname.toString());
                            if (newtrace == null) {
                                TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + String.format(Messages.SynchronizeTracesHandler_CopyProblem, origtrace.getName()));
                                continue;
                            }
                            ITmfTrace trace = newtrace.instantiateTrace();
                            ITmfEvent traceEvent = newtrace.instantiateEvent();
                            try {
                                trace.initTrace(newtrace.getResource(), newtrace.getResource().getLocation().toOSString(), traceEvent.getClass());
                            }
                            catch (TmfTraceException e) {
                                Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingForTrace, exp.getName(), traceel.getName()), e);
                                TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + e.getMessage());
                            }
                            trace.setTimestampTransform(syncAlgo.getTimestampTransform(expTrace));
                            TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)trace);
                            trace.dispose();
                            tracesToAdd.add(newtrace);
                            tracesToRemove.add(traceel);
                        }
                        experiment.dispose();
                        IFolder tmpFolder = exp.getTraceSupplementaryFolder(String.valueOf(exp.getName()) + '.' + experiment.getSynchronizationFolder(false));
                        IResource syncFile = null;
                        IResource[] iResourceArray = exp.getSupplementaryResources();
                        int newname = iResourceArray.length;
                        int n = 0;
                        while (n < newname) {
                            IResource resource = iResourceArray[n];
                            if (resource.getName().equals(experiment.getSynchronizationFolder(false))) {
                                try {
                                    resource.move(tmpFolder.getFullPath(), false, null);
                                    syncFile = resource;
                                    break;
                                }
                                catch (CoreException e) {
                                    Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingExperiment, exp.getName()), e);
                                }
                            }
                            ++n;
                        }
                        for (TmfTraceElement trace : tracesToRemove) {
                            try {
                                exp.removeTrace(trace);
                            }
                            catch (CoreException e) {
                                Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingForTrace, exp.getName(), trace.getName()), e);
                                TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + e.getMessage());
                            }
                        }
                        for (TmfTraceElement trace : tracesToAdd) {
                            exp.addTrace(trace);
                        }
                        if (tmpFolder.exists() && syncFile != null) {
                            try {
                                tmpFolder.move(syncFile.getFullPath(), false, null);
                            }
                            catch (CoreException e) {
                                Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingExperiment, exp.getName()), e);
                            }
                        }
                    }
                });
            }
        };
        thread.start();
        return null;
    }

    static /* synthetic */ TmfTraceElement access$1(SynchronizeTracesHandler synchronizeTracesHandler) {
        return synchronizeTracesHandler.fRootNode;
    }

    static /* synthetic */ void access$2(SynchronizeTracesHandler synchronizeTracesHandler, String string) {
        synchronizeTracesHandler.fRootNodeId = string;
    }

    static /* synthetic */ String access$3(SynchronizeTracesHandler synchronizeTracesHandler) {
        return synchronizeTracesHandler.fRootNodeId;
    }
}

