/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;

public class TmfStateStatistics
implements ITmfStatistics {
    private final ITmfStateSystem fTotalsStats;
    private final ITmfStateSystem fTypesStats;

    public TmfStateStatistics(@NonNull ITmfStateSystem totals, @NonNull ITmfStateSystem eventTypes) {
        this.fTotalsStats = totals;
        this.fTypesStats = eventTypes;
    }

    public ITmfStateSystem getTotalsSS() {
        return this.fTotalsStats;
    }

    public ITmfStateSystem getEventTypesSS() {
        return this.fTypesStats;
    }

    @Override
    public void dispose() {
        this.fTotalsStats.dispose();
        this.fTypesStats.dispose();
    }

    @Override
    @Deprecated
    public List<@NonNull Long> histogramQuery(long start, long end, int nb) {
        ArrayList<@NonNull Long> list = new ArrayList<Long>();
        long increment = (end - start) / (long)nb;
        if (this.fTotalsStats.isCancelled()) {
            return list;
        }
        long prevTotal = start == this.fTotalsStats.getStartTime() ? 0L : this.getEventCountAt(start);
        long curTime = start + increment;
        int i = 0;
        while (i < nb - 1) {
            long curTotal = this.getEventCountAt(curTime);
            long count = curTotal - prevTotal;
            list.add(count);
            curTime += increment;
            prevTotal = curTotal;
            ++i;
        }
        long curTotal = this.getEventCountAt(end);
        list.add(curTotal - prevTotal);
        return list;
    }

    @Override
    public List<@NonNull Long> histogramQuery(long[] timeRequested) {
        ArrayList<@NonNull Long> list = new ArrayList<Long>();
        if (this.fTotalsStats.isCancelled()) {
            return list;
        }
        long prevTotal = timeRequested[0] == this.fTotalsStats.getStartTime() ? 0L : this.getEventCountAt(timeRequested[0] - 1L);
        int i = 0;
        while (i < timeRequested.length) {
            long curTotal = this.getEventCountAt(timeRequested[i]);
            long count = curTotal - prevTotal;
            list.add(count);
            prevTotal = curTotal;
            ++i;
        }
        return list;
    }

    @Override
    public long getEventsTotal() {
        long endTime = this.fTotalsStats.getCurrentEndTime();
        int quark = this.fTotalsStats.optQuarkAbsolute(new String[]{"total"});
        if (quark == -2) {
            return 0L;
        }
        try {
            return TmfStateStatistics.extractCount(this.fTotalsStats.querySingleState(endTime, quark).getValue());
        }
        catch (StateSystemDisposedException e) {
            return 0L;
        }
    }

    @Override
    public Map<@NonNull String, @NonNull Long> getEventTypesTotal() {
        int quark = this.fTypesStats.optQuarkAbsolute(new String[]{"event_types"});
        if (quark == -2) {
            return Collections.emptyMap();
        }
        List quarks = this.fTypesStats.getSubAttributes(quark, false);
        long endTime = this.fTypesStats.getCurrentEndTime();
        HashMap<@NonNull String, @NonNull Long> map = new HashMap<String, Long>();
        try {
            List endState = this.fTypesStats.queryFullState(endTime);
            Iterator iterator = quarks.iterator();
            while (iterator.hasNext()) {
                int typeQuark = (Integer)iterator.next();
                String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                long eventCount = TmfStateStatistics.extractCount(((ITmfStateInterval)endState.get(typeQuark)).getValue());
                map.put(curEventName, eventCount);
            }
            return map;
        }
        catch (StateSystemDisposedException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public long getEventsInRange(long start, long end) {
        long startCount = start == this.fTotalsStats.getStartTime() ? 0L : this.getEventCountAt(start - 1L);
        long endCount = this.getEventCountAt(end);
        return endCount - startCount;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        long startTime = Long.max(start, this.fTypesStats.getStartTime());
        long endTime = Long.min(end, this.fTypesStats.getCurrentEndTime());
        if (endTime < startTime) {
            return Collections.emptyMap();
        }
        int quark = this.fTypesStats.optQuarkAbsolute(new String[]{"event_types"});
        if (quark == -2) {
            return Collections.emptyMap();
        }
        List quarks = this.fTypesStats.getSubAttributes(quark, false);
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            List endState = this.fTypesStats.queryFullState(endTime);
            if (startTime == this.fTypesStats.getStartTime()) {
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                    Object eventCount = ((ITmfStateInterval)endState.get(typeQuark)).getValue();
                    map.put(curEventName, TmfStateStatistics.extractCount(eventCount));
                }
            } else {
                List startState = this.fTypesStats.queryFullState(startTime - 1L);
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                    Object countAtStart = ((ITmfStateInterval)startState.get(typeQuark)).getValue();
                    Object countAtEnd = ((ITmfStateInterval)endState.get(typeQuark)).getValue();
                    long eventCount = TmfStateStatistics.extractCount(countAtEnd) - TmfStateStatistics.extractCount(countAtStart);
                    map.put(curEventName, eventCount);
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return map;
    }

    private long getEventCountAt(long timestamp) {
        long ts = Long.max(this.fTotalsStats.getStartTime(), timestamp);
        ts = Long.min(ts, this.fTotalsStats.getCurrentEndTime());
        int quark = this.fTotalsStats.optQuarkAbsolute(new String[]{"total"});
        if (quark == -2) {
            return 0L;
        }
        try {
            return TmfStateStatistics.extractCount(this.fTotalsStats.querySingleState(ts, quark).getValue());
        }
        catch (StateSystemDisposedException e) {
            return 0L;
        }
    }

    private static long extractCount(@Nullable Object state) {
        if (state instanceof Number) {
            return ((Number)state).longValue();
        }
        return 0L;
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String EVENT_TYPES = "event_types";
        public static final String LOST_EVENTS = "lost_events";
    }
}

