/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenValueScript
extends DataDrivenValue {
    public static final String DEFAULT_SCRIPT_ENGINE = "nashorn";
    private final Map<String, DataDrivenValue> fValues;
    private final String fScriptEngine;
    private final String fScript;

    public DataDrivenValueScript(@Nullable String mappingGroupId, ITmfStateValue.Type forcedType, Map<String, DataDrivenValue> values, String script, String scriptEngine) {
        super(mappingGroupId, forcedType);
        this.fScriptEngine = !scriptEngine.isEmpty() ? scriptEngine : DEFAULT_SCRIPT_ENGINE;
        this.fValues = values;
        this.fScript = script;
    }

    @Override
    protected @Nullable Object resolveValue(int quark, IAnalysisDataContainer container) {
        return this.executeScript(sv -> sv.resolveValue(quark, container), container);
    }

    @Override
    protected @Nullable Object resolveValue(ITmfEvent event, int quark, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        return this.executeScript(sv -> sv.resolveValue(event, quark, scenarioInfo, container), container);
    }

    private @Nullable Object executeScript(Function<DataDrivenValue, @Nullable Object> function, IAnalysisDataContainer container) {
        ScriptEngineManager manager;
        Object result = null;
        ScriptEngine engine = null;
        engine = container.getScriptEngine(this.fScriptEngine);
        if (engine == null && (engine = (manager = new ScriptEngineManager()).getEngineByName(this.fScriptEngine)) != null) {
            container.setScriptengine(this.fScriptEngine, engine);
        }
        if (engine == null) {
            Activator.logWarning("Unknown script engine: " + this.fScriptEngine);
            return null;
        }
        for (Map.Entry<String, DataDrivenValue> entry : this.fValues.entrySet()) {
            String stateValueId = Objects.requireNonNull(entry.getKey());
            DataDrivenValue stateValue = Objects.requireNonNull(entry.getValue());
            Object value = function.apply(stateValue);
            engine.put(stateValueId, value);
        }
        try {
            result = engine.eval(this.fScript);
        }
        catch (ScriptException e) {
            Activator.logError("Script execution failed", e);
            return TmfStateValue.nullValue();
        }
        return result;
    }

    @Override
    public String toString() {
        return "TmfXmlValueScript: " + this.fScript + " -> " + this.fValues;
    }
}

