/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IBaseQuarkProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.w3c.dom.Element;

public class TmfXmlStateSystemPathCu
implements IDataDrivenCompilationUnit {
    private final IBaseQuarkProvider fQuarkProvider;
    private final List<TmfXmlStateValueCu> fAttributes;

    public TmfXmlStateSystemPathCu(List<TmfXmlStateValueCu> attribs, IBaseQuarkProvider quarkProvider) {
        this.fAttributes = attribs;
        this.fQuarkProvider = quarkProvider;
    }

    @Override
    public DataDrivenStateSystemPath generate() {
        List<DataDrivenValue> attributes = this.fAttributes.stream().map(TmfXmlStateValueCu::generate).collect(Collectors.toList());
        return new DataDrivenStateSystemPath(attributes, this.fQuarkProvider);
    }

    public static @Nullable TmfXmlStateSystemPathCu compile(AnalysisCompilationData analysisData, List<Element> elements) {
        IBaseQuarkProvider quarkProvider = IBaseQuarkProvider.IDENTITY_BASE_QUARK;
        ArrayList<TmfXmlStateValueCu> subAttribs = new ArrayList<TmfXmlStateValueCu>();
        for (Element subAttributeNode : elements) {
            List<TmfXmlStateValueCu> subAttrib = TmfXmlStateValueCu.compileAttribute(analysisData, subAttributeNode);
            if (subAttrib == null) {
                return null;
            }
            if (subAttrib.size() == 1 && subAttrib.get(0) == TmfXmlStateValueCu.CURRENT_SCENARIO_QUARK) {
                quarkProvider = IBaseQuarkProvider.CURRENT_SCENARIO_BASE_QUARK;
                continue;
            }
            subAttribs.addAll(subAttrib);
        }
        return new TmfXmlStateSystemPathCu(subAttribs, quarkProvider);
    }
}

