/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.Token;
import org.eclipse.tm4e.core.logger.ILogger;

class LineTokens {
    private final ILogger logger;
    private final String _lineText;
    private final List<IToken> _tokens;
    private boolean _emitBinaryTokens;
    private final List<Integer> _binaryTokens;
    private int _lastTokenEndIndex;

    LineTokens(boolean emitBinaryTokens, String lineText, ILogger logger) {
        this._emitBinaryTokens = emitBinaryTokens;
        String string = this._lineText = logger.isEnabled() ? lineText : null;
        if (this._emitBinaryTokens) {
            this._tokens = null;
            this._binaryTokens = new ArrayList<Integer>();
        } else {
            this._tokens = new ArrayList<IToken>();
            this._binaryTokens = null;
        }
        this._lastTokenEndIndex = 0;
        this.logger = logger;
    }

    public void produce(StackElement stack, int endIndex) {
        this.produceFromScopes(stack.contentNameScopesList, endIndex);
    }

    public void produceFromScopes(ScopeListElement scopesList, int endIndex) {
        if (this._lastTokenEndIndex >= endIndex) {
            return;
        }
        if (this._emitBinaryTokens) {
            int metadata = scopesList.metadata;
            if (this._binaryTokens.size() > 0 && this._binaryTokens.get(this._binaryTokens.size() - 1) == metadata) {
                this._lastTokenEndIndex = endIndex;
                return;
            }
            this._binaryTokens.add(this._lastTokenEndIndex);
            this._binaryTokens.add(metadata);
            this._lastTokenEndIndex = endIndex;
            return;
        }
        List<String> scopes = scopesList.generateScopes();
        if (this.logger.isEnabled()) {
            this.logger.log("  token: |" + this._lineText.substring(this._lastTokenEndIndex, endIndex).replaceAll("\n", "\\n") + '|');
            int k = 0;
            while (k < scopes.size()) {
                this.logger.log("      * " + scopes.get(k));
                ++k;
            }
        }
        this._tokens.add(new Token(this._lastTokenEndIndex, endIndex, scopes));
        this._lastTokenEndIndex = endIndex;
    }

    public IToken[] getResult(StackElement stack, int lineLength) {
        if (this._tokens.size() > 0 && this._tokens.get(this._tokens.size() - 1).getStartIndex() == lineLength - 1) {
            this._tokens.remove(this._tokens.size() - 1);
        }
        if (this._tokens.size() == 0) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._tokens.get(this._tokens.size() - 1).setStartIndex(0);
        }
        return this._tokens.toArray(new IToken[0]);
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public int[] getBinaryResult(StackElement stack, int lineLength) {
        if (this._binaryTokens.size() > 0 && this._binaryTokens.get(this._binaryTokens.size() - 2) == lineLength - 1) {
            this._binaryTokens.remove(this._binaryTokens.size() - 1);
            this._binaryTokens.remove(this._binaryTokens.size() - 1);
        }
        if (this._binaryTokens.size() == 0) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._binaryTokens.set(this._binaryTokens.size() - 2, 0);
        }
        int[] result = new int[this._binaryTokens.size()];
        int i = 0;
        int len = this._binaryTokens.size();
        while (i < len) {
            result[i] = this._binaryTokens.get(i);
            ++i;
        }
        return result;
    }
}

