/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Replace;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.PrepareForReplaceVisitor;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.IWorkbenchPart;

public class ReplaceOperation
extends UpdateOperation {
    private Set prepDeletedFiles;
    private boolean ignoreResourcesIfTagDoesNotExist;

    public ReplaceOperation(IWorkbenchPart part, IResource[] resources, CVSTag tag, boolean recurse) {
        super(part, ReplaceOperation.asResourceMappers(resources, recurse ? 2 : 1), new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, tag);
    }

    public ReplaceOperation(IWorkbenchPart part, ResourceMapping[] mappings, CVSTag tag) {
        super(part, mappings, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, tag);
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.ReplaceOperation_taskName;
    }

    @Override
    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        try {
            ResourcesPlugin.getWorkspace().run(monitor1 -> {
                try {
                    iStatusArray[0] = this.internalExecuteCommand(session, provider, resources, recurse, monitor1);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }, null, 1, monitor);
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
        return status[0];
    }

    private IStatus internalExecuteCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        ICVSResource[] managedResources = this.getResourcesToUpdate(resources, Policy.subMonitorFor(monitor, 5));
        if (this.ignoreResourcesIfTagDoesNotExist && managedResources.length == 0) {
            return OK;
        }
        try {
            PrepareForReplaceVisitor pfrv = new PrepareForReplaceVisitor(session, this.getTag());
            pfrv.visitResources(provider.getProject(), resources, CVSUIMessages.ReplaceOperation_1, recurse ? 2 : 1, Policy.subMonitorFor(monitor, 25));
            this.prepDeletedFiles = pfrv.getDeletedFiles();
            IStatus status = OK;
            if (managedResources.length > 0) {
                status = super.executeCommand(session, provider, managedResources, recurse, Policy.subMonitorFor(monitor, 70));
            }
            if (status.isOK() && CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                new PruneFolderVisitor().visit(session, resources);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected ICVSResource[] getResourcesToUpdate(ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        ArrayList managedResources = new ArrayList();
        monitor.beginTask(null, resources.length * 100);
        int i = 0;
        while (i < resources.length) {
            byte[] syncBytes;
            ICVSResource resource = resources[i];
            if (resource.isFolder() && ((ICVSFolder)resource).isCVSFolder()) {
                this.addResourceIfTagExists(managedResources, resource, Policy.subMonitorFor(monitor, 100));
            } else if (!resource.isFolder() && (syncBytes = ((ICVSFile)resource).getSyncBytes()) != null && !ResourceSyncInfo.isAddition((byte[])syncBytes)) {
                this.addResourceIfTagExists(managedResources, resource, Policy.subMonitorFor(monitor, 100));
            }
            ++i;
        }
        monitor.done();
        return managedResources.toArray(new ICVSResource[managedResources.size()]);
    }

    private void addResourceIfTagExists(List managedResources, ICVSResource resource, IProgressMonitor monitor) {
        CVSTag tag = this.getTag();
        if (tag == null || tag.getType() == 3 || tag.isHeadTag() || tag.isBaseTag()) {
            managedResources.add(resource);
        } else {
            TagSource tagSource = TagSource.create(new ICVSResource[]{resource});
            if (this.isTagPresent(tagSource, tag)) {
                managedResources.add(resource);
            } else {
                try {
                    tagSource.refresh(false, monitor);
                    if (this.isTagPresent(tagSource, tag)) {
                        managedResources.add(resource);
                    } else {
                        tagSource.refresh(true, monitor);
                        if (this.isTagPresent(tagSource, tag)) {
                            managedResources.add(resource);
                        }
                    }
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    private boolean isTagPresent(TagSource tagSource, CVSTag tag) {
        CVSTag[] tags = tagSource.getTags(TagSource.convertIncludeFlaqsToTagTypes(31));
        return Arrays.asList(tags).contains(tag);
    }

    @Override
    protected Update getUpdateCommand() {
        return new Replace(this.prepDeletedFiles);
    }

    @Override
    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.ReplaceOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    public void ignoreResourcesWithMissingTag() {
        this.ignoreResourcesIfTagDoesNotExist = true;
    }
}

