/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.internal.tool.command.builders;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.description.tool.OperandCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OrderedElementCreationTool;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceCreatedEventsFlaggingSiriusCommand;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.tools.internal.command.builders.ContainerCreationCommandBuilder;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class OperandCreationCommandBuilder
extends ContainerCreationCommandBuilder {
    protected EventEnd startingEndPredecessor;
    protected EventEnd finishingEndPredecessor;

    public OperandCreationCommandBuilder(OperandCreationTool tool, DDiagramElementContainer nodeContainer, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        super((ContainerCreationDescription)tool, nodeContainer);
        this.startingEndPredecessor = startingEndPredecessor;
        this.finishingEndPredecessor = finishingEndPredecessor;
    }

    protected DCommand buildCreateNodeCommandFromTool(EObject semanticContainer, EObject container) {
        DCommand result = this.createEnclosingCommand();
        if (this.permissionAuthority.canEditInstance(container)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticContainer);
            HashMap<Object, EObject> variables = new HashMap<Object, EObject>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getVariable(), semanticContainer);
            variables.put(this.tool.getViewVariable(), container);
            if (this.tool instanceof OrderedElementCreationTool) {
                OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
                variables.put(orderedElementCreationTool.getStartingEndPredecessor(), this.startingEndPredecessor);
                variables.put(orderedElementCreationTool.getFinishingEndPredecessor(), this.finishingEndPredecessor);
            }
            this.addDiagramVariable(result, container, interpreter);
            result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)this.diagram, semanticContainer, this.tool.getInitialOperation().getFirstModelOperations()));
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected DCommand createEnclosingCommand() {
        return new SequenceCreatedEventsFlaggingSiriusCommand(this.editingDomain, this.getEnclosingCommandLabel(), this.diagram, Operand.viewpointElementPredicate());
    }

    protected boolean evaluatePrecondition(IInterpreter interpreter, EObject semanticContainer, String precondition) {
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.setVariable(orderedElementCreationTool.getStartingEndPredecessor().getName(), (Object)this.startingEndPredecessor);
            interpreter.setVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName(), (Object)this.finishingEndPredecessor);
        }
        boolean result = super.evaluatePrecondition(interpreter, semanticContainer, precondition);
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.unSetVariable(orderedElementCreationTool.getStartingEndPredecessor().getName());
            interpreter.unSetVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName());
        }
        return result;
    }
}

