/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views.TaskRepository;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.wizards.NewRepositoryWizard;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class TaskRepositoriesView
extends WorkbenchView {
    private static final Logger log = Logger.getLogger(TaskRepositoriesView.class);
    public static final String TITLE = "Task Repositories";

    public TaskRepositoriesView() {
        super(TITLE);
    }

    public void saveTask() {
        new ShellMenuItem(new String[]{"File", "Save"}).select();
    }

    public void createLocalTask(List<TreeItem> repoItems, ArrayList<String> repoList) {
        int elementIndex = repoList.indexOf("Local");
        log.info("Found Local Task Repo: '" + repoItems.get(elementIndex).getText() + "'");
        repoItems.get(elementIndex).select();
        new ShellMenuItem(new String[]{"File", "New", "Other..."}).select();
        new DefaultTree();
        DefaultTreeItem theNewTask = new DefaultTreeItem(new String[]{"Tasks", "Task"});
        theNewTask.select();
        new PushButton("Next >").click();
        new DefaultTree();
        DefaultTreeItem theLocalRepo = new DefaultTreeItem(new String[]{"Local"});
        theLocalRepo.select();
        new PushButton("Finish").click();
    }

    public void activateTask(String taskName) {
        new ShellMenuItem(new String[]{"Navigate", "Activate Task..."}).select();
        DefaultShell shellThatTakesLongTimeToClose = new DefaultShell("Activate Task");
        new DefaultText().setText(taskName);
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)shellThatTakesLongTimeToClose), TimePeriod.LONG);
    }

    public void openTask(String taskName) {
        new ShellMenuItem(new String[]{"Navigate", "Open Task..."}).select();
        DefaultShell shellThatTakesLongTimeToClose = new DefaultShell("Open Task");
        new DefaultText().setText(taskName);
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)shellThatTakesLongTimeToClose), TimePeriod.LONG);
    }

    public void deactivateTask() {
        new ShellMenuItem(new String[]{"Navigate", "Deactivate Task"}).select();
    }

    public void deleteTask() {
        new ShellMenuItem(new String[]{"Edit", "Delete"}).select();
        new PushButton("Yes").click();
    }

    public NewRepositoryWizard newTaskRepositories() {
        log.info("Creating new repository");
        new ContextMenuItem(new String[]{"New", "Add Task Repository..."}).select();
        new DefaultShell("Add Task Repository...");
        return new NewRepositoryWizard();
    }

    public List<TaskRepository> getTaskRepositories() {
        Tree tree;
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        try {
            tree = this.getRepositoriesTree();
        }
        catch (SWTLayerException sWTLayerException) {
            log.debug("No Task repository is defined");
            return new ArrayList<TaskRepository>();
        }
        for (TreeItem item : tree.getAllItems()) {
            log.debug("Found Task repository: " + item.getText());
            repositories.add(new TaskRepository(item));
        }
        return repositories;
    }

    public TaskRepository getTaskRepository(String name) {
        for (TaskRepository repository : this.getTaskRepositories()) {
            if (!repository.getName().equals(name)) continue;
            return repository;
        }
        throw new EclipseLayerException("There is no repository with name " + name);
    }

    protected Tree getRepositoriesTree() {
        return new DefaultTree();
    }
}

