/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractSimplePartitionFactory
extends AbstractPartitionFactory<RuleRegion> {
    protected final @NonNull MappingPartitioner mappingPartitioner;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final boolean hasSynthesizedTrace;
    private final @NonNull List<@NonNull Node> nodes = new ArrayList<Node>();

    protected AbstractSimplePartitionFactory(@NonNull MappingPartitioner mappingPartitioner) {
        super(mappingPartitioner.getScheduleManager(), (RuleRegion)mappingPartitioner.getRegion());
        this.mappingPartitioner = mappingPartitioner;
        this.transformationAnalysis = mappingPartitioner.getRegionAnalysis().getTransformationAnalysis();
        this.hasSynthesizedTrace = this.scheduleManager.useActivators();
    }

    @Override
    protected void addEdge(@NonNull BasicPartition partition, @NonNull Edge edge, @NonNull Role newEdgeRole) {
        assert (edge.getOwningRegion() == this.region);
        Role oldEdgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        switch (oldEdgeRole) {
            case CONSTANT: 
            case CONSTANT_SUCCESS_FALSE: 
            case CONSTANT_SUCCESS_TRUE: {
                assert (newEdgeRole == Role.CONSTANT);
                break;
            }
            case LOADED: {
                assert (newEdgeRole == Role.LOADED);
                break;
            }
            case PREDICATED: {
                assert (newEdgeRole == Role.PREDICATED || newEdgeRole == Role.SPECULATED);
                break;
            }
            case REALIZED: {
                if (!this.mappingPartitioner.hasRealizedEdge(edge) ? !$assertionsDisabled && newEdgeRole != Role.REALIZED : !$assertionsDisabled && newEdgeRole != Role.PREDICATED) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addEdge " + edge);
            }
        }
        super.addEdge(partition, edge, newEdgeRole);
    }

    @Override
    protected void addEdge2(@NonNull BasicPartition partition, @NonNull Edge edge, @NonNull Role newEdgeRole) {
        super.addEdge2(partition, edge, newEdgeRole);
        this.mappingPartitioner.addEdge(edge, newEdgeRole, partition);
    }

    protected void addNode(@NonNull BasicPartition partition, @NonNull Node node) {
        Role oldNodeRole = QVTscheduleUtil.getNodeRole((Node)node);
        this.addNode(partition, node, oldNodeRole);
    }

    protected void addNode(@NonNull BasicPartition partition, @NonNull Node node, @NonNull Role newNodeRole) {
        assert (node.getOwningRegion() == this.region);
        Role oldNodeRole = QVTscheduleUtil.getNodeRole((Node)node);
        switch (oldNodeRole) {
            case CONSTANT: 
            case CONSTANT_SUCCESS_FALSE: 
            case CONSTANT_SUCCESS_TRUE: {
                assert (newNodeRole == Role.CONSTANT);
                break;
            }
            case LOADED: {
                assert (newNodeRole == Role.LOADED);
                break;
            }
            case PREDICATED: 
            case SPECULATED: {
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                this.mappingPartitioner.addCheckedNode(node);
                break;
            }
            case REALIZED: {
                if (!this.mappingPartitioner.hasRealizedNode(node)) {
                    this.mappingPartitioner.addRealizedNode(node);
                    break;
                }
                if (node instanceof SuccessNode) {
                    assert (newNodeRole == Role.CONSTANT_SUCCESS_TRUE);
                    break;
                }
                if (newNodeRole == Role.REALIZED || newNodeRole == Role.SPECULATION) {
                    assert (false);
                    return;
                }
                assert (newNodeRole == Role.PREDICATED || newNodeRole == Role.SPECULATED);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".addNode " + node);
            }
        }
        Role displacedNodeRole = partition.putNodeRole(node, newNodeRole);
        assert (displacedNodeRole == null || displacedNodeRole == newNodeRole);
        this.nodes.add(node);
    }

    protected @NonNull String computeName(@NonNull String suffix) {
        return String.valueOf(QVTscheduleUtil.getName((Nameable)this.region)) + "\u00ab" + suffix + "\u00bb";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        @NonNull ArrayList navigableEdges = Lists.newArrayList(this.mappingPartitioner.getOldPrimaryNavigableEdges());
        for (Edge edge : this.mappingPartitioner.getAlreadyRealizedEdges()) {
            if (!(edge instanceof NavigableEdge)) continue;
            navigableEdges.add((NavigableEdge)edge);
        }
        return navigableEdges;
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        List<@NonNull Node> traceNodes = this.mappingPartitioner.getTraceNodes();
        Iterable<@NonNull Node> constantInputNodes = this.mappingPartitioner.getConstantInputNodes();
        return Iterables.concat(traceNodes, constantInputNodes);
    }

    protected boolean isAvailable(@NonNull BasicPartition partition, @NonNull Node node) {
        Role role = partition.getRole(node);
        return role != null ? role.isOld() : false;
    }

    @Override
    protected @Nullable Role resolveCheckedEdgeRole(@NonNull Edge edge, @NonNull Role edgeRole) {
        assert (edgeRole != Role.REALIZED);
        if (edge.isCast() || edge.isNavigation()) {
            if (this.mappingPartitioner.hasRealizedEdge(edge)) {
                return null;
            }
            if (this.mappingPartitioner.hasCheckedEdge(edge)) {
                return null;
            }
            if (this.mappingPartitioner.hasLoadedEdge(edge)) {
                return null;
            }
            if (this.mappingPartitioner.hasConstantEdge(edge)) {
                return null;
            }
        }
        return edgeRole;
    }

    protected void resolveDisambiguations(@NonNull BasicPartition partition) {
        for (Node traceNode : this.mappingPartitioner.getTraceNodes()) {
            TraceClassRegionAnalysis traceClassAnalysis = this.mappingPartitioner.getTraceClassAnalysis(traceNode);
            Iterable<@NonNull Property> discriminatingProperties = traceClassAnalysis.getDiscriminatingProperties();
            if (discriminatingProperties == null) continue;
            for (Property property : discriminatingProperties) {
                Node targetNode = traceNode.getNavigableTarget(property);
                assert (targetNode != null);
                if (partition.hasNode(targetNode)) continue;
                this.addNode(partition, targetNode);
            }
        }
    }

    protected void resolvePrecedingNodes(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        int i = 0;
        while (i < this.nodes.size()) {
            boolean hasSourceNode;
            Node node = this.nodes.get(i);
            assert (node != null);
            Edge traceEdge = this.mappingPartitioner.getTraceEdge(node);
            Node sourceNode = traceEdge != null ? QVTscheduleUtil.getSourceNode((Edge)traceEdge) : null;
            boolean bl = hasSourceNode = sourceNode != null && partition.hasNode(sourceNode);
            if (traceEdge == null || !this.mappingPartitioner.hasRealizedEdge(traceEdge) || !hasSourceNode) {
                Role edgeRole;
                boolean gotOne = false;
                for (Node precedingNode : partitionAnalysis.getPredecessors(node)) {
                    gotOne = true;
                    if (partition.hasNode(precedingNode)) continue;
                    this.addNode(partition, precedingNode, this.mappingPartitioner.hasRealizedNode(precedingNode) ? Role.PREDICATED : QVTscheduleUtil.getNodeRole((Node)precedingNode));
                }
                if (!gotOne && traceEdge != null && (edgeRole = partition.getRole(traceEdge)) != null && edgeRole.isRealized()) {
                    gotOne = true;
                    if (!hasSourceNode) {
                        assert (sourceNode != null);
                        this.addNode(partition, sourceNode);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    protected @Nullable Role resolveReachingEdgeRole(@NonNull BasicPartition partition, @NonNull Set<@NonNull Edge> reachingEdges, @NonNull Edge edge, @NonNull Role edgeRole) {
        assert (edgeRole == Role.REALIZED);
        if (!this.mappingPartitioner.hasRealizedEdge(edge)) {
            return edgeRole;
        }
        if (reachingEdges.contains(edge)) {
            return Role.PREDICATED;
        }
        return null;
    }

    public @NonNull String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.mappingPartitioner;
    }
}

