/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractBaseHandler
extends AbstractHandler {
    private List<Object> cachedSelections;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext context;
        this.resetCachedValues();
        try {
            context = this.getIEvaluationContext(event);
        }
        catch (NotFoundException e) {
            return null;
        }
        if (!this.preExecute(event, context)) {
            return null;
        }
        this.executeTransaction(event, context);
        this.postExecute(event, context);
        return null;
    }

    protected void resetCachedValues() {
        this.cachedSelections = null;
    }

    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        return true;
    }

    protected void postExecute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
    }

    private void executeTransaction(ExecutionEvent event, final IEvaluationContext context) {
        TransactionalEditingDomain editingDomain;
        final ExecutionEvent finalEvent = event;
        try {
            editingDomain = this.lookupTransactionalEditingDomain(context);
        }
        catch (ServiceException e) {
            return;
        }
        RecordingCommand cmd = new RecordingCommand(editingDomain, this.getCommandName()){

            protected void doExecute() {
                try {
                    AbstractBaseHandler.this.doExecute(finalEvent, context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected List<Object> getCachedSelections(IEvaluationContext context) {
        if (this.cachedSelections == null) {
            this.cachedSelections = this.getSelections(context);
        }
        return this.cachedSelections;
    }

    protected List<Object> getSelections(IEvaluationContext context) {
        Object sel = context.getVariable("selection");
        if (!(sel instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)sel;
        return structuredSelection.toList();
    }

    protected <T> List<T> getSelectionsByType(IEvaluationContext context, Class<T> expectedType) {
        List<Object> selections = this.getCachedSelections(context);
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object obj : selections) {
            Object ele = null;
            if (obj instanceof IAdaptable) {
                ele = ((IAdaptable)obj).getAdapter(expectedType);
            }
            if (ele == null) {
                ele = Platform.getAdapterManager().getAdapter(obj, expectedType);
            }
            if (ele == null) continue;
            results.add(ele);
        }
        return results;
    }

    public abstract String getCommandName();

    protected abstract void doExecute(ExecutionEvent var1, IEvaluationContext var2);

    protected IEvaluationContext getIEvaluationContext(ExecutionEvent event) throws NotFoundException {
        try {
            return (IEvaluationContext)event.getApplicationContext();
        }
        catch (ClassCastException e) {
            throw new NotFoundException("IEvaluationContext can't be found.");
        }
    }

    protected TransactionalEditingDomain lookupTransactionalEditingDomain(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain((Object)context);
    }

    protected ServicesRegistry lookupServicesRegistry(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getServiceRegistry(context);
    }

    public void setEnabled(Object evaluationContext) {
        this.resetCachedValues();
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        List<Object> selections = this.getCachedSelections(context);
        this.setBaseEnabled(this.isEnabled(context, selections));
    }

    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return true;
    }

    protected Diagram lookupNotationDiagramChecked(IEvaluationContext context) throws NotFoundException, ServiceException {
        IEditorPart editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        return diagram;
    }

    protected boolean selectionFirstElementInstanceOf(List<Object> selections, Class<?> type) {
        if (selections.size() != 1) {
            return false;
        }
        Object first = selections.get(0);
        return type.isInstance(first);
    }
}

