/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.localizer.IObjectLocalizer;
import org.eclipse.papyrus.infra.services.localizer.util.LocalizerUtil;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class DropTargetListener
extends DiagramDropTargetListener {
    public static final String EVENT_DETAIL = "EVENT_DETAIL";

    public DropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected Request createTargetRequest() {
        Request r = super.createTargetRequest();
        if (r != null && r.getExtendedData() != null) {
            r.getExtendedData().put(EVENT_DETAIL, this.getCurrentEvent().detail);
            boolean isSnapping = ((DiagramGraphicalViewer)this.getViewer()).getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.snaptogrid");
            r.getExtendedData().put("rulergrid.snaptogrid", isSnapping);
        }
        return r;
    }

    protected abstract Object getJavaObject(TransferData var1);

    protected List<EObject> getObjectsBeingDropped() {
        TransferData data = this.getCurrentEvent().currentDataType;
        ArrayList uris = new ArrayList();
        Object transferedObject = this.getJavaObject(data);
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (transferedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)transferedObject;
            ResourceSet localSet = this.getTransactionalEditingDomain().getResourceSet();
            IObjectLocalizer localizer = LocalizerUtil.getInstance((ResourceSet)localSet);
            for (Object nextSelectedObject : selection) {
                EObject local;
                if (!((nextSelectedObject = EMFHelper.getEObject(nextSelectedObject)) instanceof EObject) || (local = localizer.getLocalEObject(localSet, (EObject)nextSelectedObject)) == null) continue;
                result.add(local);
            }
        }
        for (URI uri : uris) {
            EObject modelObject = this.getTransactionalEditingDomain().getResourceSet().getEObject(uri, true);
            result.add(modelObject);
        }
        return result;
    }

    protected abstract TransactionalEditingDomain getTransactionalEditingDomain();
}

