/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearFilterCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.config.DefaultFilterRowConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.papyrus.infra.nattable.dataprovider.FilterRowDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;

public class FilterRowDataLayer<T>
extends DataLayer {
    public static final String FILTER_ROW_COLUMN_LABEL_PREFIX = "FILTER_COLUMN_";
    public static final String PERSISTENCE_KEY_FILTER_ROW_TOKENS = ".filterTokens";

    public FilterRowDataLayer(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, INattableModelManager tableManager) {
        super(new FilterRowDataProvider<T>(filterStrategy, columnHeaderLayer, columnHeaderDataProvider, tableManager));
        this.addConfiguration((IConfiguration)new DefaultFilterRowConfiguration());
    }

    public FilterRowDataProvider<T> getFilterRowDataProvider() {
        return (FilterRowDataProvider)this.dataProvider;
    }

    public boolean doCommand(ILayerCommand command) {
        boolean handled = false;
        if (command instanceof ClearFilterCommand && command.convertToTargetLayer((ILayer)this)) {
            int columnPosition = ((ClearFilterCommand)command).getColumnPosition();
            this.dataProvider.setDataValue(columnPosition, 0, null);
            handled = true;
        } else if (command instanceof ClearAllFiltersCommand) {
            this.getFilterRowDataProvider().clearAllFilters();
            handled = true;
        }
        if (handled) {
            this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
            return true;
        }
        return super.doCommand(command);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        labels.addLabel(FILTER_ROW_COLUMN_LABEL_PREFIX + columnPosition);
        labels.addLabel("FILTER_ROW");
        return labels;
    }
}

