/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.ui.actions.SaveAttachmentsAction;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.CopyAttachmentToClipboardJob;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class TasksUiMenus {
    public static void fillTaskAttachmentMenu(IMenuManager manager) {
        SaveAttachmentsAction saveAction = new SaveAttachmentsAction(Messages.TasksUiMenus_Save_);
        Action copyURLToClipAction = new Action(Messages.TasksUiMenus_Copy_URL){

            public void run() {
                ITaskAttachment attachment = AttachmentUtil.getSelectedAttachment();
                if (attachment != null) {
                    Clipboard clip = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                    clip.setContents(new Object[]{attachment.getUrl()}, new Transfer[]{TextTransfer.getInstance()});
                    clip.dispose();
                }
            }

            public boolean isEnabled() {
                ITaskAttachment attachment = AttachmentUtil.getSelectedAttachment();
                if (attachment != null) {
                    return attachment.getUrl() != null;
                }
                return super.isEnabled();
            }
        };
        Action copyToClipAction = new Action(Messages.TasksUiMenus_Copy_Contents){

            public void run() {
                ITaskAttachment attachment = AttachmentUtil.getSelectedAttachment();
                if (attachment != null) {
                    CopyAttachmentToClipboardJob job = new CopyAttachmentToClipboardJob(attachment);
                    job.setUser(true);
                    job.schedule();
                }
            }
        };
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new Separator("group.save"));
        manager.add((IAction)saveAction);
        manager.add((IAction)copyURLToClipAction);
        manager.add((IAction)copyToClipAction);
        manager.add((IContributionItem)new Separator("additions"));
    }
}

