/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.operations.Messages;
import org.eclipse.mylyn.internal.tasks.core.operations.TaskListOperation;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;
import org.eclipse.osgi.util.NLS;

public class RefactorTaskIdsOperation
extends TaskListOperation {
    private final Map<ITask, String> newTaskIdMap;
    private final TaskActivityManager activityManager;
    private final AbstractTaskContextStore contextStore;
    private final TaskDataManager taskDataManager;

    public RefactorTaskIdsOperation(Map<ITask, String> newTaskIdMap, TaskList taskList, TaskActivityManager activityManager, AbstractTaskContextStore contextStore, TaskDataManager taskDataManager) {
        super(ITasksCoreConstants.ROOT_SCHEDULING_RULE, taskList);
        this.newTaskIdMap = newTaskIdMap;
        this.activityManager = activityManager;
        this.contextStore = contextStore;
        this.taskDataManager = taskDataManager;
    }

    @Override
    protected void operations(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.RefactorTaskIdsOperation_UpdateTaskId, this.newTaskIdMap.size() * 2);
            HashMap<ITask, ITask> map = new HashMap<ITask, ITask>();
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, null, null);
            for (ITask task : this.newTaskIdMap.keySet()) {
                AbstractTask newTask = this.getTaskList().refactorTaskId(task, this.newTaskIdMap.get(task));
                map.put(task, newTask);
                this.activityManager.moveActivity(task, newTask);
                if (task instanceof AbstractTask) {
                    try {
                        this.taskDataManager.refactorTaskId((AbstractTask)task, newTask);
                    }
                    catch (CoreException e) {
                        status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)Messages.RefactorTaskIdsOperation_TaskDataRefactorError, (Object)task), (Throwable)e));
                    }
                }
                monitor.worked(1);
            }
            this.contextStore.moveContext(map);
            monitor.worked(this.newTaskIdMap.size());
            this.handleFailedMigrations(status);
        }
        finally {
            monitor.done();
        }
    }

    private void handleFailedMigrations(MultiStatus status) throws CoreException {
        if (!status.isOK()) {
            MultiStatus errorStatus = new MultiStatus("org.eclipse.mylyn.tasks.core", 4, NLS.bind((String)Messages.RefactorTaskIdsOperation_FailedTaskCount, (Object)status.getChildren().length), null);
            errorStatus.merge((IStatus)status);
            throw new CoreException((IStatus)errorStatus);
        }
    }
}

