/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import com.ibm.icu.text.NumberFormat;

public abstract class Units {
    private static NumberFormat nf = NumberFormat.getInstance();

    static {
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Plain {
        BASE(null, 1L),
        THOUSANDS("k", 1000L),
        MILLIONS("m", 1000000L);

        private final String symbol;
        private final long divider;

        private Plain(String name, long divider) {
            this.symbol = name;
            this.divider = divider;
        }

        public static Plain of(long number) {
            long n;
            long l = n = number > 0L ? -number : number;
            if (n > -1000L) {
                return BASE;
            }
            if (n > -1000000L) {
                return THOUSANDS;
            }
            return MILLIONS;
        }

        public String format(long number) {
            String f = nf.format((double)number / (double)this.divider);
            return this.symbol != null ? String.valueOf(f) + this.symbol : f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Storage {
        BYTE("B", 1L),
        KILOBYTE("KB", 1024L),
        MEGABYTE("MB", 0x100000L),
        GIGABYTE("GB", 0x40000000L);

        private final String symbol;
        private final long divider;

        private Storage(String name, long divider) {
            this.symbol = name;
            this.divider = divider;
        }

        public static Storage of(long number) {
            long n;
            long l = n = number > 0L ? -number : number;
            if (n > -1024L) {
                return BYTE;
            }
            if (n > -1048576L) {
                return KILOBYTE;
            }
            if (n > -1073741824L) {
                return MEGABYTE;
            }
            return GIGABYTE;
        }

        public String format(long number) {
            return String.valueOf(nf.format((double)number / (double)this.divider)) + " " + this.symbol;
        }
    }
}

