/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.core;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.internal.vagrant.core.Activator;
import org.eclipse.linuxtools.internal.vagrant.core.EnvironmentsManager;
import org.eclipse.linuxtools.internal.vagrant.core.Messages;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantBox;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantBoxRefreshManager;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantVM;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantVMRefreshManager;
import org.eclipse.linuxtools.vagrant.core.EnumVMStatus;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.linuxtools.vagrant.core.IVagrantBoxListener;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.IVagrantVMListener;
import org.osgi.framework.Version;

public class VagrantConnection
implements IVagrantConnection,
Closeable {
    private static final String JSCH_ID = "org.eclipse.jsch.core";
    private static final String KEY = "PRIVATEKEY";
    private static final String VG = "vagrant";
    private final Object imageLock = new Object();
    private final Object containerLock = new Object();
    private List<IVagrantVM> vms;
    private boolean containersLoaded = false;
    private List<IVagrantBox> boxes;
    private boolean boxesLoaded = false;
    private Set<String> trackedKeys = new HashSet<String>();
    ListenerList<IVagrantVMListener> vmListeners;
    ListenerList<IVagrantBoxListener> boxListeners;

    public VagrantConnection() {
        VagrantBoxRefreshManager vbrm = VagrantBoxRefreshManager.getInstance();
        VagrantVMRefreshManager vvrm = VagrantVMRefreshManager.getInstance();
        this.addBoxListener(vbrm);
        this.addVMListener(vvrm);
    }

    @Override
    public void close() {
    }

    @Override
    public void addVMListener(IVagrantVMListener listener) {
        if (this.vmListeners == null) {
            this.vmListeners = new ListenerList(1);
        }
        this.vmListeners.add((Object)listener);
    }

    @Override
    public void removeVMListener(IVagrantVMListener listener) {
        if (this.vmListeners != null) {
            this.vmListeners.remove((Object)listener);
        }
    }

    public void notifyContainerListeners(List<IVagrantVM> list) {
        if (this.vmListeners != null) {
            for (IVagrantVMListener listener : this.vmListeners) {
                listener.listChanged(this, list);
            }
        }
    }

    @Override
    public void addBoxListener(IVagrantBoxListener listener) {
        if (this.boxListeners == null) {
            this.boxListeners = new ListenerList(1);
        }
        this.boxListeners.add((Object)listener);
    }

    @Override
    public void removeBoxListener(IVagrantBoxListener listener) {
        if (this.boxListeners != null) {
            this.boxListeners.remove((Object)listener);
        }
    }

    public void notifyBoxListeners(List<IVagrantBox> list) {
        if (this.boxListeners != null) {
            for (IVagrantBoxListener listener : this.boxListeners) {
                listener.listChanged(this, list);
            }
        }
    }

    @Override
    public List<IVagrantVM> getVMs(boolean force) {
        if (force || !this.isVMsLoaded()) {
            this.refreshVMs();
        }
        return this.vms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshVMs() {
        String[] res = VagrantConnection.call(new String[]{"global-status"});
        LinkedList<String> vmIDs = new LinkedList<String>();
        LinkedList<String> vmDirs = new LinkedList<String>();
        final LinkedList<IVagrantVM> containers = new LinkedList<IVagrantVM>();
        int i = 0;
        while (i < res.length) {
            String[] items = res[i].split("\\s+");
            if (items.length == 5 && i >= 2) {
                vmIDs.add(items[0]);
                vmDirs.add(items[items.length - 1]);
            }
            ++i;
        }
        final ArrayList completed = new ArrayList();
        if (!vmIDs.isEmpty()) {
            Iterator vmIterator = vmIDs.iterator();
            Iterator vmDirIterator = vmDirs.iterator();
            while (vmIterator.hasNext()) {
                final String vmid = (String)vmIterator.next();
                final String vmDir = (String)vmDirIterator.next();
                new Thread("Checking ssh-config for vm " + vmid){

                    @Override
                    public void run() {
                        try {
                            VagrantVM ret = VagrantConnection.this.createVagrantVM(vmid, vmDir);
                            if (ret != null) {
                                containers.add(ret);
                            }
                        }
                        finally {
                            completed.add(vmid);
                        }
                    }
                }.start();
            }
        }
        while (completed.size() < vmIDs.size()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Collections.sort(containers, (o1, o2) -> o1.name().compareTo(o2.name()));
        this.containersLoaded = true;
        Object object = this.containerLock;
        synchronized (object) {
            this.vms = containers;
        }
        this.removeKeysFromInnactiveVMs();
        this.notifyContainerListeners(this.vms);
    }

    private VagrantVM createVagrantVM(String vmid, String vmDir) {
        Map<String, String> env = EnvironmentsManager.getSingleton().getEnvironment(new File(vmDir));
        LinkedList<String> args = new LinkedList<String>(Arrays.asList("ssh-config"));
        args.add(vmid);
        ArrayList<String> sshConfig = null;
        String[] res = VagrantConnection.call(args.toArray(new String[0]), new File(vmDir), env);
        int i = 0;
        while (i < res.length) {
            String[] items = res[i].trim().split(" ");
            if (items[0].equals("HostName")) {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(items[1]);
                sshConfig = tmp;
            } else if (items[0].equals("User") || items[0].equals("Port")) {
                sshConfig.add(items[1]);
            } else if (items[0].equals("IdentityFile")) {
                sshConfig.add(items[1].replace("\"", ""));
            }
            ++i;
        }
        VagrantVM vm = null;
        args = new LinkedList<String>(Arrays.asList("--machine-readable", "status"));
        args.add(vmid);
        res = VagrantConnection.call(args.toArray(new String[0]), new File(vmDir), env);
        String state_desc = "";
        String state = "";
        String provider = "";
        String name = "";
        int i2 = 0;
        while (i2 < res.length) {
            String[] items = res[i2].split(",");
            if (items[2].equals("provider-name")) {
                name = items[1];
                provider = items[3];
            } else if (items[2].equals("state")) {
                state = items[3];
            } else if (items[2].equals("state-human-long")) {
                state_desc = items[3];
                vm = sshConfig == null || sshConfig.isEmpty() ? new VagrantVM(vmid, name, provider, state, state_desc, new File(vmDir), null, null, 0, null) : new VagrantVM(vmid, name, provider, state, state_desc, new File(vmDir), (String)sshConfig.get(0), (String)sshConfig.get(1), Integer.parseInt((String)sshConfig.get(2)), (String)sshConfig.get(3));
            }
            ++i2;
        }
        return vm;
    }

    private void removeKeysFromInnactiveVMs() {
        String newKeys = "";
        String keys = InstanceScope.INSTANCE.getNode(JSCH_ID).get(KEY, "");
        if (keys.isEmpty()) {
            keys = DefaultScope.INSTANCE.getNode(JSCH_ID).get(KEY, "");
        }
        boolean vmFound = false;
        String[] stringArray = keys.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            for (IVagrantVM vm : this.vms) {
                if (!key.equals(vm.identityFile())) continue;
                vmFound = true;
                if (EnumVMStatus.RUNNING.equals((Object)EnumVMStatus.fromStatusMessage(vm.state()))) continue;
                newKeys = this.removeFromKeys(keys, key);
                this.removeFromTrackedKeys(key);
                break;
            }
            if (!vmFound && this.isTrackedKey(key)) {
                newKeys = this.removeFromKeys(keys, key);
                this.removeFromTrackedKeys(key);
            }
            ++n2;
        }
        if (!newKeys.isEmpty() && !newKeys.equals(keys)) {
            InstanceScope.INSTANCE.getNode(JSCH_ID).put(KEY, newKeys);
        }
    }

    @Override
    public void addToTrackedKeys(String key) {
        this.trackedKeys.add(key);
    }

    private void removeFromTrackedKeys(String key) {
        this.trackedKeys.remove(key);
    }

    private String removeFromKeys(String keys, String key) {
        StringBuffer res = new StringBuffer();
        String[] stringArray = keys.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (!key.equals(k)) {
                res.append(",");
                res.append(k);
            }
            ++n2;
        }
        return res.substring(1);
    }

    public boolean isTrackedKey(String key) {
        return this.trackedKeys.contains(key);
    }

    @Override
    public List<IVagrantVM> getVMs() {
        return this.getVMs(false);
    }

    @Override
    public boolean isVMsLoaded() {
        return this.containersLoaded;
    }

    @Override
    public boolean isBoxesLoaded() {
        return this.boxesLoaded;
    }

    @Override
    public List<IVagrantBox> getBoxes() {
        return this.getBoxes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IVagrantBox> getBoxes(boolean force) {
        if (force || !this.isBoxesLoaded()) {
            String[] res = VagrantConnection.call(new String[]{"--machine-readable", "box", "list"});
            LinkedList<IVagrantBox> images = new LinkedList<IVagrantBox>();
            String name = "";
            String provider = "";
            String version = "0";
            int i = 0;
            while (i < res.length) {
                String[] items = res[i].split(",");
                if (items[2].equals("box-name")) {
                    name = items[3];
                } else if (items[2].equals("box-provider")) {
                    provider = items[3];
                } else if (items[2].equals("box-version")) {
                    version = items[3];
                    images.add(new VagrantBox(name, provider, Version.parseVersion((String)version)));
                    name = "";
                    provider = "";
                    version = "0";
                }
                ++i;
            }
            this.boxesLoaded = true;
            Object object = this.imageLock;
            synchronized (object) {
                this.boxes = images;
            }
            this.notifyBoxListeners(this.boxes);
        }
        return this.boxes;
    }

    @Override
    public void init(File vagrantDir) {
        VagrantConnection.call(new String[]{"init"}, vagrantDir);
    }

    @Override
    public void up(File vagrantDir, String provider) {
        this.up(vagrantDir, provider, EnvironmentsManager.getSingleton().getEnvironment(vagrantDir));
    }

    private void up(File vagrantDir, String provider, Map<String, String> environment) {
        if (provider != null) {
            VagrantConnection.rtCall(new String[]{"up", "--provider", provider}, vagrantDir, environment);
        } else {
            VagrantConnection.rtCall(new String[]{"up"}, vagrantDir, environment);
        }
    }

    @Override
    public void addBox(String name, String location, boolean progress) {
        if (progress) {
            VagrantConnection.rtCall(new String[]{"box", "add", name, location}, null, null);
        } else {
            VagrantConnection.call(new String[]{"--machine-readable", "box", "add", name, location});
        }
    }

    @Override
    public void destroyVM(IVagrantVM vm) {
        VagrantConnection.call(new String[]{"destroy", "-f", vm.id()}, vm.directory(), EnvironmentsManager.getSingleton().getEnvironment(vm.directory()));
    }

    @Override
    public void haltVM(IVagrantVM vm) {
        VagrantConnection.call(new String[]{"--machine-readable", "halt", vm.id()}, vm.directory(), EnvironmentsManager.getSingleton().getEnvironment(vm.directory()));
    }

    @Override
    public void startVM(IVagrantVM vm) {
        this.up(vm.directory(), vm.provider(), EnvironmentsManager.getSingleton().getEnvironment(vm.directory()));
    }

    @Override
    public void removeBox(String name) {
        VagrantConnection.call(new String[]{"--machine-readable", "box", "remove", name});
    }

    @Override
    public void packageVM(IVagrantVM vm, String name) {
        VagrantConnection.rtCall(new String[]{"package", vm.id(), "--output", name}, vm.directory(), null);
    }

    @Override
    public String getName() {
        return Messages.VagrantConnection_sys_vagrant_conn;
    }

    private static String[] call(String[] args) {
        return VagrantConnection.call(args, null);
    }

    private static String[] call(String[] args, File vagrantDir) {
        return VagrantConnection.call(args, vagrantDir, null);
    }

    private static String[] call(String[] args, File vagrantDir, Map<String, String> env) {
        ArrayList<String> result;
        block5: {
            String[] envp = EnvironmentsManager.convertEnvironment(env);
            result = new ArrayList<String>();
            try {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(VG);
                cmd.addAll(Arrays.asList(args));
                Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]), envp, vagrantDir);
                BufferedReader buff = new BufferedReader(new InputStreamReader(p.getInputStream()));
                if (p.waitFor() == 0) {
                    String line;
                    while ((line = buff.readLine()) != null) {
                        result.add(line);
                    }
                    break block5;
                }
                return new String[0];
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result.toArray(new String[0]);
    }

    private static void rtCall(String[] args, File vagrantDir, Map<String, String> environment) {
        String EXTERNAL_TOOLS = "org.eclipse.ui.externaltools.ProgramLaunchConfigurationType";
        String UI_PLUGIN_ID = "org.eclipse.ui.externaltools";
        String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
        String ATTR_TOOL_ARGUMENTS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";
        String ATTR_WORKING_DIRECTORY = "org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY";
        String arguments = Arrays.asList(args).stream().map(u -> u.toString()).collect(Collectors.joining(" "));
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            String vagrantPath = VagrantConnection.findVagrantPath();
            ILaunchConfigurationWorkingCopy wc = type.newInstance(null, VG);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", vagrantPath);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", vagrantDir != null ? vagrantDir.getAbsolutePath() : null);
            wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environment);
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            Activator.log(e1);
        }
    }

    public static String findVagrantPath() {
        Path vgPath;
        String vgName = "win32".equals(Platform.getOS()) ? "vagrant.exe" : VG;
        String userDefinedVagrantPath = VagrantConnection.getUserDefinedVagrantPath();
        if (userDefinedVagrantPath != null && (vgPath = Paths.get(userDefinedVagrantPath, vgName)).toFile().exists()) {
            return vgPath.toString();
        }
        String envPath = System.getenv("PATH");
        if (envPath != null) {
            String[] stringArray = envPath.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Path vgPath2;
                String dir = stringArray[n2];
                if ('\"' == dir.charAt(0) && '\"' == dir.charAt(dir.length() - 1)) {
                    dir = dir.substring(1, dir.length() - 1);
                }
                if ((vgPath2 = Paths.get(dir, vgName)).toFile().exists()) {
                    return vgPath2.toString();
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getUserDefinedVagrantPath() {
        String userDefinedVagrantPath = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.vagrant.ui").get("vagrantPath", null);
        String defaultDefinedVagrantPath = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.vagrant.ui").get("vagrantPath", null);
        return userDefinedVagrantPath != null ? userDefinedVagrantPath : defaultDefinedVagrantPath;
    }
}

