/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.data.DataFactory;
import org.eclipse.jwt.meta.model.data.DataType;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.model.SelectDatatypeWizardPage;
import org.eclipse.jwt.we.misc.wizards.model.SelectNameWizardPage;
import org.eclipse.ui.IWorkbench;

public class CreateDataWizard
extends Wizard {
    protected SelectNameWizardPage initialPage;
    protected SelectDatatypeWizardPage datatypePage;
    protected Package defaultPackage = null;

    public CreateDataWizard() {
        this.setWindowTitle(PluginProperties.wizards_DataWizard_title);
    }

    public CreateDataWizard(Package defaultPackage) {
        this();
        this.defaultPackage = defaultPackage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialPage = new SelectNameWizardPage(org.eclipse.jwt.meta.PluginProperties.model_Data_type, this.defaultPackage, workbench);
        this.datatypePage = new SelectDatatypeWizardPage(org.eclipse.jwt.meta.PluginProperties.model_DataType_type, workbench);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.initialPage);
        this.initialPage.setDescription(PluginProperties.wizards_Page_name_package);
        this.addPage((IWizardPage)this.datatypePage);
        this.datatypePage.setDescription(PluginProperties.wizards_Page_datatype);
    }

    public boolean performFinish() {
        String name = this.initialPage.getName();
        Package selectedPackage = this.initialPage.getPackage();
        String icon = this.initialPage.getIconPath();
        DataType datatype = this.datatypePage.getDataType();
        String value = this.datatypePage.getValue();
        DataFactory factory = DataFactory.eINSTANCE;
        Data data = factory.createData();
        data.setName(name);
        data.setIcon(icon);
        data.setDataType(datatype);
        data.setValue(value);
        CommandParameter childDescriptor = new CommandParameter(null, (Object)CorePackage.Literals.PACKAGE__ELEMENTS, (Object)data);
        Command cmd = CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)selectedPackage, (Object)childDescriptor, Collections.singleton(selectedPackage));
        this.getEditingDomain().getCommandStack().execute(cmd);
        return true;
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }
}

