/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.DefaultFactoryRegistry;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.managed.views.ViewsAction;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.internal.Serialization;
import org.eclipse.jwt.we.misc.views.ViewDescriptor;
import org.eclipse.jwt.we.misc.views.ViewItemWrapper;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars2;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Views {
    private Logger logger = Logger.getLogger(Views.class);
    private static Views myinstance;
    private static final String viewdirectory = "views/";
    private ArrayList<ViewDescriptor> availableViews = new ArrayList();
    private ViewDescriptor selectedView;
    private String defaultViewName = "Technical";

    private Views() {
        String obj;
        this.collectViews();
        if (this.availableViews.size() > 0) {
            boolean found = false;
            for (ViewDescriptor vD : this.availableViews) {
                if (!vD.getInternalName().equals(this.defaultViewName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.defaultViewName = this.availableViews.get(0).getInternalName();
            }
        }
        obj = (obj = PreferenceReader.viewSelected.get()) == null ? this.defaultViewName : obj;
        ViewDescriptor defaultViewDescriptor = null;
        boolean found = false;
        for (ViewDescriptor vD : this.availableViews) {
            if (vD.getInternalName().equals(obj.toString())) {
                found = true;
                this.selectedView = vD;
                break;
            }
            if (!vD.getInternalName().equals(this.defaultViewName)) continue;
            defaultViewDescriptor = vD;
        }
        if (!found) {
            this.selectedView = defaultViewDescriptor;
        }
    }

    public static Views getInstance() {
        if (myinstance == null) {
            myinstance = new Views();
        }
        return myinstance;
    }

    private void collectViews() {
        String extension_point_id = PluginProperties.extension_point_view;
        this.logger.debug("get views from extension point " + extension_point_id);
        try {
            IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(extension_point_id);
            if (confElements == null) {
                this.logger.info("no external views found");
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = confElements;
            int n = confElements.length;
            int n2 = 0;
            while (n2 < n) {
                URL viewPath;
                IConfigurationElement point = iConfigurationElementArray[n2];
                Bundle bundle = Platform.getBundle((String)point.getContributor().getName());
                String viewID = point.getAttribute("id");
                String viewFile = point.getAttribute("viewFile");
                this.logger.info("JWT Extension - found VIEW <" + viewID + "> at " + extension_point_id + ": " + viewFile);
                IFactoryRegistry factoryRegistry = null;
                try {
                    factoryRegistry = (IFactoryRegistry)point.createExecutableExtension("factoryRegistry");
                }
                catch (Exception exception) {
                    factoryRegistry = new DefaultFactoryRegistry();
                }
                String viewName = point.getAttribute("displayName");
                viewName = viewName == null ? "" : viewName;
                ImageDescriptor viewImage = null;
                try {
                    String imageString = point.getAttribute("displayIcon");
                    URL imagePath = bundle.getEntry(imageString);
                    if (imagePath == null && imageString.length() > 3 && imageString.substring(0, 4).equals("src/")) {
                        imageString = imageString.replaceFirst("src/", "");
                        imagePath = bundle.getEntry(imageString);
                    }
                    if (imagePath != null) {
                        viewImage = ImageDescriptor.createFromURL((URL)imagePath);
                    }
                }
                catch (Exception exception) {}
                if ((viewPath = bundle.getEntry(viewFile)) == null && viewFile.length() > 3 && viewFile.substring(0, 4).equals("src/")) {
                    viewFile = viewFile.replaceFirst("src/", "");
                    viewPath = bundle.getEntry(viewFile);
                }
                if (viewPath != null) {
                    viewPath = FileLocator.resolve((URL)viewPath);
                    InputStream stream = viewPath.openStream();
                    ViewDescriptor viewDesc = this.loadViewFromFile(stream);
                    stream.close();
                    viewDesc.setFactoryRegistry(factoryRegistry);
                    viewDesc.setInternalID(viewID);
                    viewDesc.setOfficialName(viewName);
                    viewDesc.setImageDescriptor(viewImage);
                    viewDesc.setViewAction(new ViewsAction(viewDesc.getInternalName(), viewDesc.getOfficialName(), viewImage));
                } else {
                    this.logger.warning("view file " + viewFile + " could not be found");
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.warning("error loading external views");
            e.printStackTrace();
        }
    }

    public ViewDescriptor loadViewFromFile(Object file) {
        Document doc;
        block7: {
            SAXBuilder sax = new SAXBuilder();
            if (file instanceof File) {
                doc = sax.build((File)file);
                break block7;
            }
            if (file instanceof InputStream) {
                doc = sax.build((InputStream)file);
                break block7;
            }
            return null;
        }
        try {
            Element rootnode = doc.getRootElement();
            ViewDescriptor viewDesc = new ViewDescriptor();
            viewDesc.setInternalID(rootnode.getChild("viewname").getText());
            viewDesc.setViewData((Hashtable)Serialization.createObject(rootnode.getChild("viewdata")));
            boolean viewExists = false;
            for (ViewDescriptor vD : this.availableViews) {
                if (!vD.getInternalName().equals(viewDesc.getInternalName())) continue;
                viewExists = true;
            }
            if (!viewExists) {
                this.availableViews.add(viewDesc);
            }
            this.selectedView = viewDesc;
            return viewDesc;
        }
        catch (Exception ex) {
            this.logger.debug(ex);
            return null;
        }
    }

    public void addViewItemWrapper(ViewItemWrapper newchild, ViewItemWrapper parent) {
        if (parent != null) {
            parent.addChild(newchild);
        }
        this.selectedView.getViewData().put(newchild.toString(), newchild);
    }

    public void setDisplay(ViewItemWrapper item, boolean value) {
        ViewItemWrapper obj = this.selectedView.getViewData().get(item.toString());
        if (obj == null) {
            return;
        }
        obj.setDisplay(value);
    }

    public void reset() {
        if (this.selectedView == null) {
            ViewDescriptor viewDesc = new ViewDescriptor();
            viewDesc.setInternalID("NewView");
            viewDesc.setViewData(new Hashtable<String, ViewItemWrapper>());
            this.selectedView = viewDesc;
        }
        this.selectedView.getViewData().clear();
    }

    public void saveCurrentView(File f) {
        Document doc = new Document(new Element("WorkFlowEditorView"));
        Element name = new Element("viewname");
        name.addContent(this.selectedView.getInternalName());
        doc.getRootElement().addContent((Content)name);
        try {
            Serialization.writeObjecttoXML(this.selectedView.getViewData(), doc.getRootElement(), "viewdata");
            XMLOutputter xmlout = new XMLOutputter();
            xmlout.output(doc, (OutputStream)new FileOutputStream(f));
        }
        catch (Exception ex) {
            this.logger.debug(ex);
        }
    }

    public ViewDescriptor getSelectedView() {
        return this.selectedView;
    }

    public ArrayList<ViewDescriptor> getAvailableViews() {
        return this.availableViews;
    }

    public boolean displayObject(EObject obj) {
        if (this.selectedView.getViewData() == null) {
            return false;
        }
        String name = "";
        name = obj instanceof EClass || obj instanceof EAttribute || obj instanceof EReference ? ViewItemWrapper.makeName(obj, false) : ViewItemWrapper.makeName((EObject)obj.eClass(), false);
        ViewItemWrapper vi_obj = this.selectedView.getViewData().get(name);
        if (vi_obj != null) {
            ViewItemWrapper vi = vi_obj;
            return vi.getDisplay();
        }
        return true;
    }

    public void changeView(String viewName) {
        for (ViewDescriptor vD : this.availableViews) {
            if (!vD.getInternalName().equals(viewName)) continue;
            this.selectedView = vD;
        }
        PreferenceReader.viewSelected.set(viewName);
    }

    public void refreshViewsState(final WEEditor weeditor) {
        if (weeditor != null && weeditor.getSite() == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Views.this.refreshCheckedState();
                Views.this.refreshToolbarCommand(weeditor);
            }
        });
    }

    private void refreshCheckedState() {
        ArrayList<ViewsAction> viewsActions = new ArrayList<ViewsAction>();
        for (ViewDescriptor viewDesc : Views.getInstance().getAvailableViews()) {
            ViewsAction viewAction = viewDesc.getViewAction();
            if (viewAction == null) continue;
            viewsActions.add(viewAction);
        }
        for (ViewsAction act : viewsActions) {
            act.setChecked(false);
            if (act.getId().equals(this.selectedView.getInternalName())) {
                act.setChecked(true);
            }
            act.setEnabled(act.isEnabled());
        }
    }

    private void refreshToolbarCommand(final WEEditor weEditor) {
        if (weEditor == null) {
            return;
        }
        SubActionBars2 actionBars = null;
        if (weEditor.getSite() instanceof IViewSite) {
            actionBars = (SubActionBars2)((IViewSite)weEditor.getSite()).getActionBars();
        } else if (weEditor.getSite() instanceof IEditorSite) {
            actionBars = (SubActionBars2)((IEditorSite)weEditor.getSite()).getActionBars();
        }
        ToolBarContributionItem viewGroup = (ToolBarContributionItem)actionBars.getCoolBarManager().find("org.eclipse.jwt.we.viewBar");
        if (viewGroup == null || (ToolBarManager)viewGroup.getToolBarManager() == null) {
            return;
        }
        final ToolBar tb = ((ToolBarManager)viewGroup.getToolBarManager()).getControl();
        if (tb.getItemCount() > 1) {
            if (this.selectedView.getImageDescriptor() != null) {
                tb.getItem(1).setImage(Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(this.selectedView.getImageDescriptor()));
            } else {
                tb.getItem(1).setImage(null);
            }
            try {
                String viewName = this.selectedView.getOfficialName() != null ? this.selectedView.getOfficialName() : this.selectedView.getInternalName();
                boolean tooLong = false;
                int overflowProtection = 40;
                do {
                    tb.getItem(1).setText(String.valueOf(viewName) + (tooLong ? "..." : ""));
                    tooLong = tb.getItem(1).getWidth() > 120 ? true : tooLong;
                    String string = viewName = tooLong ? viewName.substring(0, viewName.length() - 1) : viewName;
                } while (tb.getItem(1).getWidth() > 120 && overflowProtection-- > 0);
                overflowProtection = 100;
                while (tb.getItem(1).getWidth() < 120 && !tooLong && overflowProtection-- > 0) {
                    viewName = String.valueOf(viewName) + " ";
                    tb.getItem(1).setText(viewName);
                }
            }
            catch (Exception exception) {
                this.logger.warning("error updating the toolbar view dropdown");
            }
            tb.update();
            viewGroup.getToolBarManager().update(true);
        } else {
            tb.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    tb.removePaintListener((PaintListener)this);
                    Views.this.refreshViewsState(weEditor);
                }
            });
        }
    }
}

