/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.external;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.actions.external.WEExternalAction;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEExternalActionsManager {
    private static final Logger logger = Logger.getLogger(WEExternalActionsManager.class);
    private static WEExternalActionsManager myinstance = null;
    private List<WEExternalAction> externalActionList = new ArrayList<WEExternalAction>();

    private WEExternalActionsManager() {
        if (this.externalActionList.size() == 0) {
            this.readActions();
        }
    }

    public static WEExternalActionsManager getInstance() {
        if (myinstance == null) {
            myinstance = new WEExternalActionsManager();
        }
        return myinstance;
    }

    private void readActions() {
        String extension_point_id = PluginProperties.extension_point_menu;
        try {
            IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(extension_point_id);
            if (confElements == null) {
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = confElements;
            int n = confElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement point = iConfigurationElementArray[n2];
                WEExternalAction action = (WEExternalAction)((Object)point.createExecutableExtension("class"));
                action.setText(point.getAttribute("name"));
                action.setDescription(point.getAttribute("description"));
                action.setId(String.valueOf(point.getAttribute("name")) + "ExternalAction");
                if (point.getAttribute("showInMenu").equals("true")) {
                    action.setShowInMenu(true);
                } else {
                    action.setShowInMenu(false);
                }
                if (point.getAttribute("showInToolbar").equals("true")) {
                    action.setShowInToolbar(true);
                } else {
                    action.setShowInToolbar(false);
                }
                if (point.getAttribute("requiresOpenEditor").equals("true")) {
                    action.setRequiresOpenEditor(true);
                } else {
                    action.setRequiresOpenEditor(false);
                }
                if (point.getAttribute("forceText").equals("true")) {
                    action.setForceText(true);
                } else {
                    action.setForceText(false);
                }
                if (action.getImage() != null) {
                    action.setImageDescriptor(action.getImage());
                }
                this.externalActionList.add(action);
                logger.info("JWT Extension - found ACTION at " + extension_point_id + ": " + action.getText());
                ++n2;
            }
        }
        catch (Exception e) {
            logger.severe("Extension point load failed for " + extension_point_id, e);
        }
    }

    public List<WEExternalAction> getExternalActions() {
        return (ArrayList)this.externalActionList;
    }
}

