/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformation.stpim.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLTransformation {
    private static ATLTransformation instance = null;
    private static final String resourcePath = "/org/eclipse/jwt/transformation/stpim/internal/resources/";
    private AtlEMFModelHandler modelHandler;
    private ModelLoader modelLoader;
    private InputStream JWT_ModelResource;
    private InputStream STPIM_ModelResource;
    private URL JWT2STPIM_TransfoResource;
    private ASMEMFModel jwtMetamodel;
    private ASMEMFModel stpimMetamodel;

    public static ATLTransformation getInstance() {
        if (instance == null) {
            instance = new ATLTransformation();
        }
        return instance;
    }

    private void createResources() throws TransformationException {
        if (this.STPIM_ModelResource == null) {
            this.modelHandler = (AtlEMFModelHandler)AtlEMFModelHandler.getDefault((String)"EMF");
            this.modelLoader = this.modelHandler.createModelLoader();
            String mm_path = "/org/eclipse/jwt/meta/ecore/JWTMetaModel.ecore";
            this.JWT_ModelResource = this.getClass().getResourceAsStream(mm_path);
            this.STPIM_ModelResource = this.getClass().getResourceAsStream("/org/eclipse/jwt/transformation/stpim/internal/resources/stpmodel.ecore");
            this.JWT2STPIM_TransfoResource = ATLTransformation.class.getResource("resources/JWT2STPIM.asm");
        }
    }

    private Map<String, Object> getMetamodels() throws TransformationException {
        HashMap<String, Object> models = new HashMap<String, Object>();
        if (this.jwtMetamodel == null) {
            try {
                this.createResources();
                this.jwtMetamodel = (ASMEMFModel)this.modelLoader.loadModel("jwt", this.modelLoader.getMOF(), this.JWT_ModelResource);
                this.stpimMetamodel = (ASMEMFModel)this.modelLoader.loadModel("stpmodel", this.modelLoader.getMOF(), this.STPIM_ModelResource);
            }
            catch (IOException ex) {
                throw new TransformationException(ex.getMessage(), (Throwable)ex);
            }
        }
        models.put("jwt", this.jwtMetamodel);
        models.put("stpmodel", this.stpimMetamodel);
        return models;
    }

    public void jwt2stpim(String inFilePath, String outFilePath) {
        try {
            Map<String, Object> models = this.getMetamodels();
            ASMEMFModel jwtInputModel = (ASMEMFModel)this.modelLoader.loadModel("IN", (ASMModel)this.jwtMetamodel, (InputStream)new FileInputStream(inFilePath));
            ASMEMFModel stpimOutputModel = (ASMEMFModel)this.modelLoader.newModel("OUT", URI.createFileURI((String)outFilePath).toFileString(), (ASMModel)this.stpimMetamodel);
            models.put("IN", jwtInputModel);
            models.put("OUT", stpimOutputModel);
            AtlLauncher.getDefault().launch(this.JWT2STPIM_TransfoResource, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            this.modelLoader.save((ASMModel)stpimOutputModel, new File(outFilePath).toURI().toURL().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stpim2jwt(String inFilePath, String outFilePath) {
        throw new UnsupportedOperationException("not yet implemented!");
    }
}

