/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.utils;

public class KeyConverter {
    private KeyConverter() {
    }

    public static int convertSwtStateMask(int stateMask) {
        if (stateMask == 262144) {
            return 128;
        }
        if (stateMask == 393216) {
            return 192;
        }
        if (stateMask == 327680) {
            return 640;
        }
        if (stateMask == 65536) {
            return 512;
        }
        if (stateMask == 196608) {
            return 576;
        }
        return -1;
    }

    public static int convertSwingStateMask(int stateMask) {
        if (stateMask == 128) {
            return 262144;
        }
        if (stateMask == 192) {
            return 393216;
        }
        if (stateMask == 640) {
            return 327680;
        }
        if (stateMask == 512) {
            return 65536;
        }
        if (stateMask == 576) {
            return 196608;
        }
        if (stateMask == 0) {
            return 0;
        }
        return -1;
    }

    static int swtCharacter(char character) {
        switch (character) {
            case '\b': {
                return 8;
            }
            case '\r': {
                return 10;
            }
            case '\u007f': {
                return 127;
            }
            case '\u001b': {
                return 27;
            }
            case '\t': {
                return 9;
            }
        }
        return character;
    }

    static int swtKeyboardMasks(int keyCode) {
        switch (keyCode) {
            case 65536: {
                return 18;
            }
            case 131072: {
                return 16;
            }
            case 262144: {
                return 17;
            }
            case 0x400000: {
                return 524;
            }
        }
        return KeyConverter.swtNonNumericKeyPadKeys(keyCode);
    }

    static int swtNonNumericKeyPadKeys(int keyCode) {
        switch (keyCode) {
            case 0x1000001: {
                return 38;
            }
            case 0x1000002: {
                return 40;
            }
            case 0x1000003: {
                return 37;
            }
            case 0x1000004: {
                return 39;
            }
            case 0x1000005: {
                return 33;
            }
            case 0x1000006: {
                return 34;
            }
            case 0x1000007: {
                return 36;
            }
            case 0x1000008: {
                return 35;
            }
            case 0x1000009: {
                return 155;
            }
        }
        return KeyConverter.swtVirtualAndAsciiKeys(keyCode);
    }

    static int swtVirtualAndAsciiKeys(int keyCode) {
        switch (keyCode) {
            case 8: {
                return 8;
            }
            case 13: {
                return 10;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 9: {
                return 9;
            }
        }
        return KeyConverter.swtFunctionKeys(keyCode);
    }

    static int swtFunctionKeys(int keyCode) {
        switch (keyCode) {
            case 0x100000A: {
                return 112;
            }
            case 0x100000B: {
                return 113;
            }
            case 0x100000C: {
                return 114;
            }
            case 0x100000D: {
                return 115;
            }
            case 0x100000E: {
                return 116;
            }
            case 0x100000F: {
                return 117;
            }
            case 0x1000010: {
                return 118;
            }
            case 0x1000011: {
                return 119;
            }
            case 0x1000012: {
                return 120;
            }
            case 0x1000013: {
                return 121;
            }
            case 0x1000014: {
                return 122;
            }
            case 0x1000015: {
                return 123;
            }
            case 0x1000016: {
                return 61440;
            }
            case 0x1000017: {
                return 61441;
            }
            case 0x1000018: {
                return 61442;
            }
        }
        return KeyConverter.swtNumericKeyPadKeys(keyCode);
    }

    static int swtNumericKeyPadKeys(int keyCode) {
        switch (keyCode) {
            case 16777259: {
                return 107;
            }
            case 16777261: {
                return 109;
            }
            case 16777258: {
                return 106;
            }
            case 16777263: {
                return 111;
            }
            case 16777262: {
                return 110;
            }
            case 0x1000050: {
                return 10;
            }
            case 0x1000030: {
                return 96;
            }
            case 0x1000031: {
                return 97;
            }
            case 16777266: {
                return 98;
            }
            case 0x1000033: {
                return 99;
            }
            case 16777268: {
                return 100;
            }
            case 16777269: {
                return 101;
            }
            case 16777270: {
                return 102;
            }
            case 16777271: {
                return 103;
            }
            case 16777272: {
                return 104;
            }
            case 16777273: {
                return 105;
            }
            case 16777277: {
                return 61;
            }
        }
        return KeyConverter.swtOtherKeys(keyCode);
    }

    static int swtOtherKeys(int keyCode) {
        switch (keyCode) {
            case 16777298: {
                return 20;
            }
            case 16777299: {
                return 144;
            }
            case 16777300: {
                return 145;
            }
            case 0x1000055: {
                return 19;
            }
            case 16777302: {
                return 65480;
            }
            case 16777303: {
                return 154;
            }
            case 0x1000051: {
                return 156;
            }
            case 32: {
                return 32;
            }
        }
        return KeyConverter.swtCharacter((char)keyCode);
    }

    static int swingCharacter(char character) {
        switch (character) {
            case '\b': {
                return 8;
            }
            case '\n': {
                return 13;
            }
            case '\u007f': {
                return 127;
            }
            case '\u001b': {
                return 27;
            }
            case '\t': {
                return 9;
            }
        }
        return character;
    }

    static int swingKeyboardMasks(int keyCode) {
        switch (keyCode) {
            case 18: {
                return 65536;
            }
            case 16: {
                return 131072;
            }
            case 17: {
                return 262144;
            }
            case 524: {
                return 0x400000;
            }
        }
        return KeyConverter.swingNonNumericKeyPadKeys(keyCode);
    }

    static int swingNonNumericKeyPadKeys(int keyCode) {
        switch (keyCode) {
            case 38: {
                return 0x1000001;
            }
            case 40: {
                return 0x1000002;
            }
            case 37: {
                return 0x1000003;
            }
            case 39: {
                return 0x1000004;
            }
            case 33: {
                return 0x1000005;
            }
            case 34: {
                return 0x1000006;
            }
            case 36: {
                return 0x1000007;
            }
            case 35: {
                return 0x1000008;
            }
            case 155: {
                return 0x1000009;
            }
        }
        return KeyConverter.swingVirtualAndAsciiKeys(keyCode);
    }

    static int swingVirtualAndAsciiKeys(int keyCode) {
        switch (keyCode) {
            case 8: {
                return 8;
            }
            case 10: {
                return 13;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 9: {
                return 9;
            }
        }
        return KeyConverter.swingFunctionKeys(keyCode);
    }

    static int swingFunctionKeys(int keyCode) {
        switch (keyCode) {
            case 112: {
                return 0x100000A;
            }
            case 113: {
                return 0x100000B;
            }
            case 114: {
                return 0x100000C;
            }
            case 115: {
                return 0x100000D;
            }
            case 116: {
                return 0x100000E;
            }
            case 117: {
                return 0x100000F;
            }
            case 118: {
                return 0x1000010;
            }
            case 119: {
                return 0x1000011;
            }
            case 120: {
                return 0x1000012;
            }
            case 121: {
                return 0x1000013;
            }
            case 122: {
                return 0x1000014;
            }
            case 123: {
                return 0x1000015;
            }
            case 61440: {
                return 0x1000016;
            }
            case 61441: {
                return 0x1000017;
            }
            case 61442: {
                return 0x1000018;
            }
        }
        return KeyConverter.swingNumericKeyPadKeys(keyCode);
    }

    static int swingNumericKeyPadKeys(int keyCode) {
        switch (keyCode) {
            case 107: {
                return 16777259;
            }
            case 109: {
                return 16777261;
            }
            case 106: {
                return 16777258;
            }
            case 111: {
                return 16777263;
            }
            case 110: {
                return 16777262;
            }
            case 10: {
                return 0x1000050;
            }
            case 96: {
                return 0x1000030;
            }
            case 97: {
                return 0x1000031;
            }
            case 98: {
                return 16777266;
            }
            case 99: {
                return 0x1000033;
            }
            case 100: {
                return 16777268;
            }
            case 101: {
                return 16777269;
            }
            case 102: {
                return 16777270;
            }
            case 103: {
                return 16777271;
            }
            case 104: {
                return 16777272;
            }
            case 105: {
                return 16777273;
            }
            case 61: {
                return 16777277;
            }
        }
        return KeyConverter.swingOtherKeys(keyCode);
    }

    static int swingOtherKeys(int keyCode) {
        switch (keyCode) {
            case 20: {
                return 16777298;
            }
            case 144: {
                return 16777299;
            }
            case 145: {
                return 16777300;
            }
            case 19: {
                return 0x1000055;
            }
            case 65480: {
                return 16777302;
            }
            case 154: {
                return 16777303;
            }
            case 156: {
                return 0x1000051;
            }
            case 32: {
                return 32;
            }
        }
        return KeyConverter.swingCharacter((char)keyCode);
    }

    public static int convertSwingToSwt(int keyCode) {
        return KeyConverter.swingKeyboardMasks(keyCode);
    }

    public static int convertSwtToSwing(int keyCode) {
        return KeyConverter.swtKeyboardMasks(keyCode);
    }
}

