/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortHeaderLayer;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.DefaultSizeUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;

public class ColumnHeaderLayerStack
extends AbstractLayerTransform {
    private final DataLayer dataLayer;

    public ColumnHeaderLayerStack(IDataProvider dataProvider, NatTableWidget.BodyLayerStack bodyLayer, final ITableWidgetInternal tableController) {
        this.dataLayer = new DataLayer(dataProvider, DefaultSizeUtils.getDefaultCellWidth(), DefaultSizeUtils.getDefaultCellHeight());
        ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.dataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        ISortModel sortModel = new ISortModel(){
            private int sortedColumn = -1;
            private SortDirectionEnum fSortDirection = SortDirectionEnum.NONE;

            public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
                this.sortedColumn = columnIndex;
                this.fSortDirection = sortDirection;
                Column column = (Column)tableController.getColumns().get(columnIndex);
                tableController.sortRows(column, ColumnHeaderLayerStack.sortDirection(sortDirection));
            }

            public boolean isColumnIndexSorted(int columnIndex) {
                return columnIndex == this.sortedColumn && this.fSortDirection != SortDirectionEnum.NONE;
            }

            public int getSortOrder(int columnIndex) {
                return 0;
            }

            public SortDirectionEnum getSortDirection(int columnIndex) {
                if (columnIndex == this.sortedColumn) {
                    return this.fSortDirection;
                }
                return SortDirectionEnum.NONE;
            }

            public void clear() {
                this.sortedColumn = -1;
                this.fSortDirection = SortDirectionEnum.NONE;
            }
        };
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)colHeaderLayer, sortModel, true);
        this.setUnderlyingLayer((ILayer)sortHeaderLayer);
    }

    protected static ColumnSortDirection sortDirection(SortDirectionEnum sortDirection) {
        ColumnSortDirection result;
        switch (sortDirection) {
            case ASC: {
                result = ColumnSortDirection.ASCENDING;
                break;
            }
            case DESC: {
                result = ColumnSortDirection.DESCENDING;
                break;
            }
            case NONE: {
                result = ColumnSortDirection.UNSORTED;
                break;
            }
            default: {
                throw new IllegalStateException("unknown sort literal");
            }
        }
        return result;
    }

    public DataLayer getDataLayer() {
        return this.dataLayer;
    }
}

