/*******************************************************************************
 * Copyright (c) 2017 Soft-Maint.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Jonathan Pepin (Soft-Maint) - Bug 517305 - Table widget refactoring #2
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.selection;

import java.util.List;

import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableColumnSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRowSelection;

public class TableAllSelection
		implements ITableRowSelection, ITableColumnSelection {

	private final List<Row> selectedRows;
	private final List<Column> selectedColumns;

	public TableAllSelection(final List<Row> selectedRows,
			final List<Column> selectedColumns) {
		this.selectedRows = selectedRows;
		this.selectedColumns = selectedColumns;
	}

	public boolean isEmpty() {
		return false;
	}

	public List<Column> getSelectedFullColumns() {
		return this.selectedColumns;
	}

	public List<Row> getSelectedFullRows() {
		return this.selectedRows;
	}

}
