/*******************************************************************************
 * Copyright (c) 2017 Soft-Maint.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Jonathan Pepin (Soft-Maint) - Bug 518184 - Contains Matcher for JUnit Assertion
 *******************************************************************************/
package org.eclipse.emf.facet.util.junit.core.internal.exported.matcher;

import java.util.Collection;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

/**
 * @noextend This class is not intended to be extended by clients.
 */
public class Contains extends BaseMatcher<Object> {

	private final Collection<?> collection;

	public Contains(final Collection<?> collection) {
		super();
		this.collection = collection;
	}

	public boolean matches(final Object item) {
		return ((Collection<?>) item).containsAll(this.collection);
	}

	public void describeTo(final Description description) {
		description.appendValueList("<[", " ; ", "]>", this.collection) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				.appendText(" not contained in "); //$NON-NLS-1$
	}

	/**
	 * Is the collection contains all of the elements in the specified
	 * collection?
	 */
	@Factory
	public static Matcher<Object> containsAll(final Collection<?> collection) {
		return new Contains(collection);
	}

}