/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionDataFile;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FilteredContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.BundleConverter;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.ProjectFolderPickerDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.ReferencedProjectPickerDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NonReferencedResourceDialog
extends TitleAreaDialog {
    private String bundle;
    private final IFile file;
    private IFile result;
    private final IProject project;
    private String className;
    private final String installLocation;
    protected Runnable okAction;
    private BundleImageCache imageCache;
    private final IEclipseContext context;

    public NonReferencedResourceDialog(Shell parentShell, IProject project, String bundle, IFile file, String installLocation, IEclipseContext context) {
        super(parentShell);
        this.project = project;
        this.bundle = bundle;
        this.file = file;
        this.installLocation = installLocation;
        this.context = context;
        if (bundle == null && installLocation != null) {
            this.bundle = FilteredContributionDialog.getBundle(installLocation);
        }
        if (file instanceof ContributionDataFile) {
            ContributionDataFile cdf = (ContributionDataFile)file;
            this.className = cdf.getContributionData().className;
        }
    }

    protected void okPressed() {
        if (this.okAction != null) {
            try {
                this.okAction.run();
                super.okPressed();
            }
            catch (Exception exception) {}
        } else {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Text label2;
        Label label;
        Composite compParent = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(compParent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        comp.setLayoutData((Object)layoutData);
        comp.setLayout((Layout)new GridLayout(2, false));
        Button defaultButton = null;
        if (this.installLocation != null) {
            label = new Label(comp, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText(Messages.NonReferencedResourceDialog_installLocation);
            label2 = new Text(comp, 16396);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label2.setText(this.installLocation);
        }
        if (this.className != null) {
            IClassContributionProvider.ContributionData cd = ((ContributionDataFile)this.file).getContributionData();
            Label label3 = new Label(comp, 0);
            label3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label3.setText(Messages.NonReferencedResourceDialog_2);
            Text label22 = new Text(comp, 16396);
            label22.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (this.bundle != null) {
                label22.setText(this.bundle);
            } else {
                label22.setText(Messages.NonReferencedResourceDialog__ast_notInABundle_ast);
            }
            Label label32 = new Label(comp, 0);
            label32.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label32.setText(Messages.NonReferencedResourceDialog_package);
            Text label4 = new Text(comp, 16396);
            label4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label4.setText(NonReferencedResourceDialog.getPackageFromClassName(this.className));
            Label label5 = new Label(comp, 0);
            label5.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label5.setText(Messages.NonReferencedResourceDialog_class);
            Text label6 = new Text(comp, 16396);
            label6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label6.setText(cd.className.substring(cd.className.lastIndexOf(46) + 1));
            if (this.bundle != null) {
                Label label7 = new Label(comp, 0);
                label7.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                label7.setText(Messages.NonReferencedResourceDialog_url);
                Text label8 = new Text(comp, 16396);
                label8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label8.setText("bundleclass://" + this.bundle + "/" + this.className);
            }
        } else {
            label = new Label(comp, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText(Messages.NonReferencedResourceDialog_bundle);
            label2 = new Text(comp, 16396);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (this.bundle != null) {
                label2.setText(this.bundle);
            } else {
                label2.setText(Messages.NonReferencedResourceDialog_ast_notInABundle_ast);
            }
            Label label7 = new Label(comp, 0);
            label7.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label7.setText(Messages.NonReferencedResourceDialog_directory);
            Text label8 = new Text(comp, 16396);
            label8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label8.setText(this.file.getFullPath().removeFirstSegments(1).removeLastSegments(1).toOSString());
            Label label3 = new Label(comp, 0);
            label3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label3.setText(Messages.NonReferencedResourceDialog_resource);
            Text label4 = new Text(comp, 16396);
            label4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label4.setText(this.file.getFullPath().lastSegment());
            if (this.bundle != null) {
                Label label5 = new Label(comp, 0);
                label5.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                label5.setText(Messages.NonReferencedResourceDialog_url);
                Text label6 = new Text(comp, 16396);
                label6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label6.setText("platform:/plugin/" + this.bundle + "/" + this.file.getFullPath().removeFirstSegments(1).toOSString());
            }
        }
        Label lblMessage = new Label(comp, 0);
        lblMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 0));
        lblMessage.setText("");
        Group group = new Group(comp, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 0));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.NonReferencedResourceDialog_Action);
        if (this.bundle != null) {
            final Button btnRequire = new Button((Composite)group, 16);
            btnRequire.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnRequire.setText(Messages.NonReferencedResourceDialog_requireBundle);
            btnRequire.setImage(this.imageCache.loadFromKey("IMG_org.eclipse.e4.tools.emf.ui.obj16.bundle"));
            btnRequire.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnRequire.getSelection()) {
                        NonReferencedResourceDialog.this.okAction = () -> NonReferencedResourceDialog.this.doRequireBundle(NonReferencedResourceDialog.this.bundle, NonReferencedResourceDialog.this.installLocation);
                    }
                }
            });
            defaultButton = btnRequire;
        }
        if (this.className != null && this.bundle != null && this.className.contains(".")) {
            final Button btnImport = new Button((Composite)group, 16);
            btnImport.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnImport.setText(Messages.NonReferencedResourceDialog_importPackage);
            btnImport.setImage(this.imageCache.create("/icons/full/obj16/package_obj.png"));
            btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnImport.getSelection()) {
                        NonReferencedResourceDialog.this.okAction = () -> {
                            IFile fileManifest = NonReferencedResourceDialog.this.project.getFile("META-INF/MANIFEST.MF");
                            try {
                                Manifest manifest = new Manifest(fileManifest.getContents());
                                String value = manifest.getMainAttributes().getValue("Import-Package");
                                String packageName = NonReferencedResourceDialog.getPackageFromClassName(NonReferencedResourceDialog.this.className);
                                value = value == null ? packageName : String.valueOf(value) + "," + packageName;
                                manifest.getMainAttributes().putValue("Import-Package", value);
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                manifest.write(bos);
                                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                                fileManifest.setContents((InputStream)bis, true, true, null);
                                NonReferencedResourceDialog.this.result = NonReferencedResourceDialog.this.file;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        };
                    }
                }
            });
        }
        if (this.bundle != null) {
            final Button btnUseAnyway = new Button((Composite)group, 16);
            btnUseAnyway.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnUseAnyway.setText(Messages.NonReferencedResourceDialog_useAnyway);
            btnUseAnyway.setImage(this.imageCache.create("/icons/full/obj16/use_anyway.gif"));
            btnUseAnyway.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnUseAnyway.getSelection()) {
                        NonReferencedResourceDialog.this.result = NonReferencedResourceDialog.this.file;
                        NonReferencedResourceDialog.this.okAction = null;
                    }
                }
            });
        } else if (this.file instanceof ContributionDataFile) {
            final ContributionDataFile cdf = (ContributionDataFile)this.file;
            final Button btnConvertToBundle = new Button((Composite)group, 16);
            btnConvertToBundle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnConvertToBundle.setText(Messages.NonReferencedResourceDialog_convertAndRequire);
            btnConvertToBundle.setImage(this.imageCache.create("/icons/full/obj16/bundle.png"));
            btnConvertToBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnConvertToBundle.getSelection()) {
                        NonReferencedResourceDialog.this.okAction = () -> {
                            try {
                                IClassContributionProvider.ContributionData contributionData = cdf.getContributionData();
                                String bundleId = BundleConverter.convertProjectToBundle(contributionData.installLocation, NonReferencedResourceDialog.this.project.getWorkspace());
                                if (bundleId != null) {
                                    IClassContributionProvider.ContributionData cdConverted = new IClassContributionProvider.ContributionData(bundleId, contributionData.className, contributionData.sourceType, contributionData.iconPath);
                                    cdConverted.installLocation = NonReferencedResourceDialog.this.installLocation;
                                    cdConverted.resourceRelativePath = Path.fromOSString((String)contributionData.iconPath).removeFirstSegments(1).toOSString();
                                    NonReferencedResourceDialog.this.doRequireBundle(bundleId, NonReferencedResourceDialog.this.installLocation);
                                    NonReferencedResourceDialog.this.result = new ContributionDataFile(cdConverted);
                                }
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)NonReferencedResourceDialog.this.getShell(), (String)Messages.NonReferencedResourceDialog_error, (String)e1.getMessage());
                            }
                        };
                    }
                }
            });
        }
        if (this.className == null) {
            Button btnCopy;
            defaultButton = btnCopy = new Button((Composite)group, 16);
            btnCopy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnCopy.setText(Messages.NonReferencedResourceDialog_copyToThisProject);
            btnCopy.setImage(this.imageCache.create("/icons/full/obj16/copy_to_project.png"));
            btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnCopy.getSelection()) {
                        NonReferencedResourceDialog.this.okAction = () -> NonReferencedResourceDialog.this.copyResourceToProject(NonReferencedResourceDialog.this.project);
                    }
                }
            });
        }
        if (this.className == null) {
            final Button btnCopy2 = new Button((Composite)group, 16);
            btnCopy2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnCopy2.setText(Messages.NonReferencedResourceDialog_copyToReferenedProject);
            btnCopy2.setImage(this.imageCache.create("/icons/full/obj16/copy_to_project.png"));
            btnCopy2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnCopy2.getSelection()) {
                        NonReferencedResourceDialog.this.okAction = () -> {
                            ReferencedProjectPickerDialog dlg = new ReferencedProjectPickerDialog(NonReferencedResourceDialog.this.getShell(), NonReferencedResourceDialog.this.project){

                                @Override
                                protected Control createContents(Composite parent) {
                                    Control ret = super.createContents(parent);
                                    this.setMessage(Messages.NonReferencedResourceDialog_selectProjectToReceiveCopy);
                                    this.setTitleImage(NonReferencedResourceDialog.this.imageCache.create("/icons/full/wizban/plugin_wiz.gif"));
                                    return ret;
                                }
                            };
                            if (dlg.open() == 0) {
                                NonReferencedResourceDialog.this.copyResourceToProject((IProject)dlg.getFirstElement());
                            }
                        };
                    }
                }
            });
        }
        if (defaultButton != null) {
            defaultButton.setSelection(true);
            defaultButton.notifyListeners(13, new Event());
        }
        return comp;
    }

    public static String getPackageFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            return className.substring(0, index);
        }
        return "";
    }

    protected Control createContents(Composite parent) {
        this.imageCache = new BundleImageCache(parent.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), this.context);
        this.getShell().addDisposeListener(e -> this.imageCache.dispose());
        Control ret = super.createContents(parent);
        this.setMessage(Messages.NonReferencedResourceDialog_resourceNotReferenced);
        String message = this.getMessage();
        this.setMessage(message);
        this.setTitle(Messages.NonReferencedResourceDialog_resourceReferenceWarning);
        this.getShell().setText(Messages.NonReferencedResourceDialog_resourceReferenceWarning);
        try {
            this.setTitleImage(this.imageCache.create("org.eclipse.e4.tools.emf.ui", "/icons/full/wizban/newefix_wizban.png"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return ret;
    }

    public IFile getResult() {
        return this.result;
    }

    public void copyResourceToProject(IProject project) {
        try {
            ProjectFolderPickerDialog dlg = new ProjectFolderPickerDialog(this.getShell(), project, this.file.getFullPath().toOSString()){

                protected Control createContents(Composite parent) {
                    Control ret = super.createContents(parent);
                    this.setMessage(Messages.NonReferencedResourceDialog_selectTheFolderResourceCopy);
                    this.setTitleImage(NonReferencedResourceDialog.this.imageCache.create("org.eclipse.e4.tools.emf.ui", "/icons/full/wizban/add_to_dir_wiz.png"));
                    return ret;
                }
            };
            if (dlg.open() == 0) {
                IPath newPath = Path.fromOSString((String)dlg.getValue());
                if (!newPath.isEmpty()) {
                    CoreUtility.createFolder((IFolder)project.getFolder(newPath));
                }
                if (this.className != null) {
                    newPath.append(String.valueOf(this.className) + ".class");
                } else {
                    String name = this.file.getFullPath().lastSegment();
                    newPath = newPath.append(name);
                }
                IFile fileClone = project.getFile(newPath);
                fileClone.create(this.file.getContents(), false, null);
                this.result = fileClone;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e1.getMessage());
        }
    }

    public void doRequireBundle(String bundle, String installLocation) {
        String version = null;
        InputStream srcStream = null;
        try {
            try {
                Manifest manifestSource;
                if (installLocation.endsWith(".jar")) {
                    ZipFile zip = new ZipFile(installLocation);
                    srcStream = zip.getInputStream(zip.getEntry("META-INF/MANIFEST.MF"));
                    manifestSource = new Manifest(srcStream);
                    zip.close();
                } else {
                    srcStream = new BufferedInputStream(new FileInputStream(String.valueOf(installLocation) + "/META-INF/MANIFEST.MF"));
                    manifestSource = new Manifest(srcStream);
                }
                version = manifestSource.getMainAttributes().getValue("Bundle-Version");
                if (version != null) {
                    version = version.replaceFirst("\\.qualifier", "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    srcStream.close();
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                srcStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            srcStream.close();
        }
        catch (Exception exception) {}
        IFile fileManifest = this.project.getFile("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = new Manifest(fileManifest.getContents());
            String value = manifest.getMainAttributes().getValue("Require-Bundle");
            if (value == null) {
                manifest.getMainAttributes().putValue("Require-Bundle", bundle);
            } else {
                value = String.valueOf(value) + "," + bundle;
                if (version != null) {
                    value = String.valueOf(value) + ";bundle-version=" + version;
                }
                manifest.getMainAttributes().putValue("Require-Bundle", value);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            manifest.write(bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            fileManifest.setContents((InputStream)bis, true, true, null);
            this.result = this.file;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }
}

