/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseDoubleIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableDoubleSingletonList
implements ImmutableDoubleList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonList(double element) {
        this.element1 = element;
    }

    @Override
    public double get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    @Override
    public double getFirst() {
        return this.element1;
    }

    @Override
    public double getLast() {
        return this.element1;
    }

    @Override
    public int indexOf(double value) {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    @Override
    public int lastIndexOf(double value) {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(DoubleArrayList.newListWith(this.element1).doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(DoubleIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public ImmutableDoubleList select(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleArrayList.newListWith(this.element1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    @Override
    public ImmutableDoubleList reject(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.element1).toImmutable();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public double sum() {
        return this.element1;
    }

    @Override
    public double max() {
        return this.element1;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double min() {
        return this.element1;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public double[] toSortedArray() {
        return new double[]{this.element1};
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public int binarySearch(double value) {
        if (Double.compare(this.element1, value) == 0) {
            return 0;
        }
        if (Double.compare(this.element1, value) < 0) {
            return -2;
        }
        return -1;
    }

    @Override
    public double dotProduct(DoubleList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return this.element1 * list.getFirst();
    }

    @Override
    public double[] toArray() {
        return new double[]{this.element1};
    }

    @Override
    public boolean contains(double value) {
        return Double.compare(this.element1, value) == 0;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public LazyDoubleIterable asReversed() {
        return ReverseDoubleIterable.adapt(this);
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleList toImmutable() {
        return this;
    }

    @Override
    public ImmutableDoubleSingletonList toReversed() {
        return this;
    }

    @Override
    public ImmutableDoubleList newWith(double element) {
        return DoubleLists.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableDoubleList newWithout(double element) {
        return Double.compare(this.element1, element) == 0 ? DoubleLists.immutable.with() : this;
    }

    @Override
    public ImmutableDoubleList newWithAll(DoubleIterable elements) {
        DoubleArrayList arrayList = DoubleArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    @Override
    public ImmutableDoubleList newWithoutAll(DoubleIterable elements) {
        return elements.contains(this.element1) ? DoubleLists.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof DoubleList)) {
            return false;
        }
        DoubleList list = (DoubleList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return Double.compare(this.element1, list.get(0)) == 0;
    }

    @Override
    public int hashCode() {
        return 31 + (int)(Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32);
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableDoubleList distinct() {
        return this;
    }

    @Override
    public ImmutableDoubleList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    @Override
    public ImmutableList<DoubleDoublePair> zipDouble(DoubleIterable iterable) {
        if (iterable.isEmpty()) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, iterable.doubleIterator().next()));
    }

    @Override
    public <T> ImmutableList<DoubleObjectPair<T>> zip(Iterable<T> iterable) {
        if (Iterate.isEmpty(iterable)) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with(PrimitiveTuples.pair(this.element1, Iterate.getFirst(iterable)));
    }
}

