/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.internal.ui.views.executables.BaseViewer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ui.progress.WorkbenchJob;

class ExecutablesContentProvider
extends ColumnLabelProvider
implements IStructuredContentProvider,
ITreeContentProvider,
IExecutablesChangeListener {
    private final TreeViewer viewer;

    public ExecutablesContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
        ExecutablesManager.getExecutablesManager().addExecutablesChangeListener((IExecutablesChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        ExecutablesManager.getExecutablesManager().removeExecutablesChangeListener((IExecutablesChangeListener)this);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ExecutablesManager) {
            ExecutablesManager em = (ExecutablesManager)inputElement;
            return em.getExecutables().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object element = cell.getElement();
        if (element instanceof Executable) {
            Executable exe = (Executable)element;
            String cellText = exe.getName();
            if (cell.getColumnIndex() == 1) {
                cellText = exe.getProject().getName();
            } else if (cell.getColumnIndex() == 2) {
                cellText = exe.getPath().toOSString();
            } else if (cell.getColumnIndex() == 3) {
                cellText = "";
                IPath path = exe.getPath();
                if (path != null && path.toFile().exists()) {
                    long fileLength = path.toFile().length();
                    cellText = Long.toString(fileLength);
                }
                cell.setImage(null);
            } else if (cell.getColumnIndex() == 4) {
                cellText = "";
                IPath path = exe.getPath();
                if (path != null && path.toFile().exists()) {
                    long modified = path.toFile().lastModified();
                    cellText = DateFormat.getDateTimeInstance((int)3, (int)3).format(new Date(modified));
                }
                cell.setImage(null);
            } else if (cell.getColumnIndex() == 5) {
                cellText = "";
                String fileExtension = exe.getPath().getFileExtension();
                if (fileExtension != null) {
                    cellText = fileExtension;
                }
            }
            cell.setText(cellText);
        }
    }

    public String getText(Object element) {
        if (element instanceof Executable) {
            return ((Executable)element).getName();
        }
        return super.getText(element);
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public void executablesListChanged() {
        new WorkbenchJob("execs list changed"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ExecutablesContentProvider.this.viewer.refresh(null);
                if (ExecutablesContentProvider.this.viewer instanceof BaseViewer) {
                    ((BaseViewer)ExecutablesContentProvider.this.viewer).packColumns();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void executablesChanged(List<Executable> executables) {
    }
}

