/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableGroupHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.Action;

public abstract class IncludeTableGroupAction
extends Action {
    protected Object selection;

    public IncludeTableGroupAction(Object selection) {
        super("", 2);
        this.selection = selection;
        this.showAvailable();
    }

    private SlotHandle getRowContainer() {
        if (this.selection instanceof RowHandle) {
            return ((RowHandle)this.selection).getContainerSlotHandle();
        }
        return null;
    }

    protected boolean isTableGroup() {
        return this.getRowContainer() != null && this.getRowContainer().getElementHandle() instanceof TableGroupHandle;
    }

    protected TableGroupHandle getTableGroup() {
        if (this.isTableGroup()) {
            return (TableGroupHandle)this.getRowContainer().getElementHandle();
        }
        return null;
    }

    private TableGroupHandleAdapter getTableGroupAdapter() {
        return HandleAdapterFactory.getInstance().getTableGroupHandleAdapter((Object)this.getTableGroup());
    }

    private void includeSlotHandle(boolean bool, int id) {
        try {
            if (bool) {
                this.getTableGroupAdapter().insertRowInSlotHandle(id);
            } else {
                this.getTableGroupAdapter().deleteRowInSlotHandle(id);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Include table group action >> Run ...");
        }
        this.includeSlotHandle(this.isChecked(), this.getGroupSlotId());
    }

    private void showAvailable() {
        if (this.getRowContainer() != null) {
            this.setChecked(this.getTableGroupAdapter().hasSlotHandleRow(this.getGroupSlotId()));
        }
    }

    protected abstract int getGroupSlotId();

    public static class IncludeTableGroupFooterAction
    extends IncludeTableGroupAction {
        private static final String ACTION_MSG_INCLUDE_HEADER = Messages.getString((String)"IncludeTableGroupFooterAction.actionMsg.includeFooter");

        public IncludeTableGroupFooterAction(Object selection) {
            super(selection);
            this.setText(ACTION_MSG_INCLUDE_HEADER);
        }

        @Override
        protected int getGroupSlotId() {
            return 1;
        }
    }

    public static class IncludeTableGroupHeaderAction
    extends IncludeTableGroupAction {
        private static final String ACTION_MSG_INCLUDE_HEADER = Messages.getString((String)"IncludeTableGroupHeaderAction.actionMsg.includeHeader");

        public IncludeTableGroupHeaderAction(Object selection) {
            super(selection);
            this.setText(ACTION_MSG_INCLUDE_HEADER);
        }

        @Override
        protected int getGroupSlotId() {
            return 0;
        }
    }
}

