/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;

@ServiceProvider(value="Services available for Booleans")
public class BooleanServices {
    @Documentation(value="Logical or.", params={@Param(name="op1", value="The first operand"), @Param(name="op2", value="The second operand")}, result="The logical or of the two operands", examples={@Example(expression="true or false", result="true"), @Example(expression="false or true", result="true"), @Example(expression="true or true", result="true"), @Example(expression="false or false", result="false")})
    public Boolean or(Boolean op1, Boolean op2) {
        return op1 != false || op2 != false;
    }

    @Documentation(value="Logical and.", params={@Param(name="op1", value="The first operand"), @Param(name="op2", value="The second operand")}, result="The logical and of the two operands", examples={@Example(expression="true and false", result="false"), @Example(expression="false and true", result="false"), @Example(expression="true and true", result="true"), @Example(expression="false and false", result="false")})
    public Boolean and(Boolean op1, Boolean op2) {
        return op1 != false && op2 != false;
    }

    @Documentation(value="Logical negation.", params={@Param(name="op1", value="The operand")}, result="The logical negation of the operand", examples={@Example(expression="not true", result="false"), @Example(expression="not false", result="true")})
    public Boolean not(Boolean op1) {
        return op1 == false;
    }

    @Documentation(value="Logical implies.", params={@Param(name="op1", value="The first operand"), @Param(name="op2", value="The second operand")}, result="The logical implies of the operands", examples={@Example(expression="true implies true", result="true"), @Example(expression="true implies false", result="false"), @Example(expression="false implies true", result="true"), @Example(expression="false implies false", result="true")})
    public Boolean implies(Boolean op1, Boolean op2) {
        Boolean result = op1 == false ? Boolean.TRUE : op2;
        return result;
    }

    @Documentation(value="Logical xor.", params={@Param(name="op1", value="The first operand"), @Param(name="op2", value="The second operand")}, result="The logical xor of the operands", examples={@Example(expression="true xor true", result="false"), @Example(expression="true xor false", result="true"), @Example(expression="false xor true", result="true"), @Example(expression="false xor false", result="false")})
    public Boolean xor(Boolean op1, Boolean op2) {
        return op1 ^ op2;
    }
}

