/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell.decorator;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PaddingDecorator
extends CellPainterWrapper {
    private final int topPadding;
    private final int rightPadding;
    private final int bottomPadding;
    private final int leftPadding;

    public PaddingDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, 2);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int padding) {
        this(interiorPainter, padding, padding, padding, padding);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int topPadding, int rightPadding, int bottomPadding, int leftPadding) {
        super(interiorPainter);
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.leftPadding + super.getPreferredWidth(cell, gc, configRegistry) + this.rightPadding;
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.topPadding + super.getPreferredHeight(cell, gc, configRegistry) + this.bottomPadding;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Rectangle interiorBounds = new Rectangle(bounds.x + this.leftPadding, bounds.y + this.topPadding, bounds.width - this.leftPadding - this.rightPadding, bounds.height - this.topPadding - this.bottomPadding);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
    }
}

