/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;

public class XmlObjectReferenceProvider
implements IReferenceProvider {
    private final XmlObjectInfo m_objectInfo;
    private final String m_defaultReference;

    public XmlObjectReferenceProvider(XmlObjectInfo objectInfo) {
        this.m_objectInfo = objectInfo;
        this.m_defaultReference = UUID.randomUUID().toString();
    }

    public String getReference() throws Exception {
        return StringUtils.defaultString((String)XmlObjectReferenceProvider.getName((ObjectInfo)this.m_objectInfo), (String)this.m_defaultReference);
    }

    public static String getName(ObjectInfo objectInfo) throws Exception {
        Property property = objectInfo.getPropertyByTitle("Name");
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        return value == Property.UNKNOWN_VALUE ? null : (String)value;
    }

    public static void generateName(XmlObjectInfo objectInfo) throws Exception {
        if (XmlObjectReferenceProvider.getName((ObjectInfo)objectInfo) == null) {
            String baseVariable;
            final HashSet variables = Sets.newHashSet();
            DocumentElement rootElement = objectInfo.getElement().getRoot();
            final String[] xName = new String[1];
            for (DocumentAttribute attribute : rootElement.getDocumentAttributes()) {
                String name = attribute.getName();
                String value = attribute.getValue();
                if (!name.startsWith("xmlns:") || !value.equals("http://www.eclipse.org/xwt")) continue;
                xName[0] = String.valueOf(name.substring("xmlns:".length())) + ":Name";
                break;
            }
            rootElement.accept(new DocumentModelVisitor(){

                public void visit(DocumentAttribute attribute) {
                    if (attribute.getName().equalsIgnoreCase(xName[0])) {
                        variables.add(attribute.getValue());
                    }
                }
            });
            String variable = baseVariable = StringUtils.uncapitalize((String)ClassUtils.getShortClassName((Class)objectInfo.getDescription().getComponentClass()));
            int variableIndex = 1;
            while (variables.contains(variable)) {
                variable = String.valueOf(baseVariable) + "_" + Integer.toString(variableIndex++);
            }
            Property property = objectInfo.getPropertyByTitle("Name");
            property.setValue((Object)variable);
        }
    }
}

