/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.eclipse.modern;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.util.WorkspaceUtils;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.modern.SourceParameters;
import org.eclipse.wb.internal.core.nls.bundle.pure.AbstractPureBundleSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstVisitorEx;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModernEclipseSource
extends AbstractPureBundleSource {
    public static final IKeyGeneratorStrategy MODERN_KEY_GENERATOR = new IKeyGeneratorStrategy(){

        public final String generateBaseKey(JavaInfo component, GenericProperty property) {
            String typeName = ModernEclipseSource.getTypeName(component).replace('.', '_');
            String componentName = component.getVariableSupport().getComponentName();
            String titleName = property.getTitle().replace(' ', '_');
            return String.valueOf(typeName) + "_" + componentName + "_" + titleName;
        }
    };
    private final String m_accessorClassName;
    private final AstEditor m_accessorEditor;

    @Override
    protected String getBundleComment() {
        return "Eclipse modern messages class";
    }

    public static List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        ArrayList sources = Lists.newArrayList();
        IType typeNLS = root.getEditor().getJavaProject().findType("org.eclipse.osgi.util.NLS");
        if (typeNLS != null) {
            IJavaElement[] packageElements = pkg.getChildren();
            int i = 0;
            while (i < packageElements.length) {
                ICompilationUnit unit = (ICompilationUnit)packageElements[i];
                IType type = unit.findPrimaryType();
                if (type != null && CodeUtils.isSuccessorOf(type, typeNLS)) {
                    try {
                        String accessorClassName = type.getFullyQualifiedName();
                        ModernEclipseSource source = new ModernEclipseSource(root, accessorClassName, null);
                        sources.add(source);
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
                ++i;
            }
        }
        return sources;
    }

    public static AbstractSource get(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        ExpressionInfo expressionInfo = ModernEclipseSource.getExpressionInfo(expression);
        if (expressionInfo != null) {
            String accessorClassName = expressionInfo.m_accessorClassName;
            ModernEclipseSource source = ModernEclipseSource.getNewOrExistingSource(component, accessorClassName, sources);
            source.onKeyAdd(component, expressionInfo.m_key);
            return source;
        }
        return null;
    }

    private static ModernEclipseSource getNewOrExistingSource(JavaInfo component, String accessorClassName, List<AbstractSource> sources) throws Exception {
        for (AbstractSource abstractSource : sources) {
            if (!(abstractSource instanceof ModernEclipseSource)) continue;
            ModernEclipseSource source = (ModernEclipseSource)abstractSource;
            if (!source.m_accessorClassName.equals(accessorClassName)) continue;
            return source;
        }
        return new ModernEclipseSource(component.getRootJava(), accessorClassName, null);
    }

    private static ExpressionInfo getExpressionInfo(Expression expression) {
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            Name qualifier = qualifiedName.getQualifier();
            if (!AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding((Expression)qualifier), "org.eclipse.osgi.util.NLS")) {
                return null;
            }
            String accessorClassName = AstNodeUtils.getFullyQualifiedName((Expression)qualifier, true);
            SimpleName keyExpression = qualifiedName.getName();
            String key = keyExpression.getIdentifier();
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, accessorClassName, (Expression)keyExpression, key);
            expression.setProperty("NLS_EXPRESSION_INFO", (Object)expressionInfo);
            return expressionInfo;
        }
        return null;
    }

    private static String accessor_getBundleName(JavaInfo component, String accessorClassName) throws Exception {
        ClassLoader editorLoader = EditorState.get(component.getEditor()).getEditorLoader();
        Class<?> accessorClass = editorLoader.loadClass(accessorClassName);
        Field bundleNameField = accessorClass.getDeclaredField("BUNDLE_NAME");
        bundleNameField.setAccessible(true);
        return (String)bundleNameField.get(null);
    }

    public ModernEclipseSource(JavaInfo root, String accessorClassName, String bundleName) throws Exception {
        super(root, bundleName != null ? bundleName : ModernEclipseSource.accessor_getBundleName(root, accessorClassName));
        if (accessorClassName != null) {
            this.m_accessorClassName = accessorClassName;
            IType accessor_type = this.m_root.getEditor().getJavaProject().findType(this.m_accessorClassName);
            ICompilationUnit accessor_unit = accessor_type.getCompilationUnit();
            this.m_accessorEditor = new AstEditor(accessor_unit);
        } else {
            this.m_accessorClassName = null;
            this.m_accessorEditor = null;
        }
    }

    @Override
    public String getTypeTitle() throws Exception {
        return "Modern Eclipse messages class " + this.m_accessorClassName;
    }

    @Override
    protected IKeyGeneratorStrategy getKeyGeneratorStrategy() {
        return MODERN_KEY_GENERATOR;
    }

    @Override
    public void apply_addKey(String key) throws Exception {
        this.addKey(key);
        super.apply_addKey(key);
    }

    @Override
    protected AbstractBundleSource.BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty property, String key) throws Exception {
        Expression expression = property.getExpression();
        String source = String.valueOf(this.m_accessorClassName) + "." + key;
        Expression newExpression = this.m_root.getEditor().replaceExpression(expression, source);
        return ModernEclipseSource.getExpressionInfo(newExpression);
    }

    @Override
    protected Expression apply_renameKey_replaceKeyExpression(AstEditor editor, Expression keyExpression, String newKey) throws Exception {
        editor.setIdentifier((SimpleName)keyExpression, newKey);
        return keyExpression;
    }

    @Override
    protected void apply_renameKeys_pre(final Map<String, String> oldToNew) throws Exception {
        this.m_accessorEditor.getAstUnit().accept((ASTVisitor)new AstVisitorEx(){

            public void postVisitEx(ASTNode node) throws Exception {
                VariableDeclarationFragment vdf;
                String fieldName;
                String newFieldName;
                FieldDeclaration fieldDeclaration;
                if (node instanceof FieldDeclaration && (fieldDeclaration = (FieldDeclaration)node).fragments().size() == 1 && (newFieldName = (String)oldToNew.get(fieldName = (vdf = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName().getIdentifier())) != null) {
                    ModernEclipseSource.this.m_accessorEditor.setIdentifier(vdf.getName(), newFieldName);
                }
            }
        });
        this.commitAccessorChanges();
    }

    @Override
    protected void apply_internalizeKeys_post(final Set<String> keys) throws Exception {
        this.m_accessorEditor.getAstUnit().accept((ASTVisitor)new AstVisitorEx(){

            public void postVisitEx(ASTNode node) throws Exception {
                VariableDeclarationFragment vdf;
                String fieldName;
                FieldDeclaration fieldDeclaration;
                if (node instanceof FieldDeclaration && (fieldDeclaration = (FieldDeclaration)node).fragments().size() == 1 && keys.contains(fieldName = (vdf = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName().getIdentifier())) {
                    ModernEclipseSource.this.m_accessorEditor.removeBodyDeclaration((BodyDeclaration)fieldDeclaration);
                }
            }
        });
        this.commitAccessorChanges();
    }

    public static ModernEclipseSource apply_create(IEditableSource editable, JavaInfo root, Object o) throws Exception {
        SourceParameters parameters = (SourceParameters)o;
        if (!parameters.m_accessorExists) {
            String template = IOUtils.toString((InputStream)ModernEclipseSource.class.getResourceAsStream("newAccessor.jvt"));
            template = StringUtils.replace((String)template, (String)"%PACKAGE_NAME%", (String)parameters.m_accessorPackage.getElementName());
            template = StringUtils.replace((String)template, (String)"%CLASS_NAME%", (String)parameters.m_accessorClassName);
            template = StringUtils.replace((String)template, (String)"%BUNDLE_NAME%", (String)parameters.m_propertyBundleName);
            IFolder accessorFolder = (IFolder)parameters.m_accessorPackage.getUnderlyingResource();
            IFile accessorFile = accessorFolder.getFile(String.valueOf(parameters.m_accessorClassName) + ".java");
            accessorFile.create((InputStream)new ByteArrayInputStream(template.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            ModernEclipseSource.createPropertyBundleFile(parameters.m_propertyPackage, parameters.m_propertyFileName, null);
            WorkspaceUtils.waitForClass(root.getEditor(), parameters.m_accessorFullClassName);
        }
        return new ModernEclipseSource(root, parameters.m_accessorFullClassName, null);
    }

    private void addKey(String key) throws Exception {
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.m_accessorEditor.getAstUnit().types().get(0);
        FieldDeclaration[] fields = typeDeclaration.getFields();
        FieldDeclaration lastFieldDeclaration = fields[fields.length - 1];
        this.m_accessorEditor.addFieldDeclaration("public static String " + key + ";", new BodyDeclarationTarget((BodyDeclaration)lastFieldDeclaration, false));
        this.commitAccessorChanges();
    }

    private void commitAccessorChanges() throws Exception {
        this.m_accessorEditor.saveChanges(true);
    }

    private static class ExpressionInfo
    extends AbstractBundleSource.BasicExpressionInfo {
        private final String m_accessorClassName;

        public ExpressionInfo(Expression expression, String accessorClassName, Expression keyExpression, String key) {
            super(expression, keyExpression, key);
            this.m_accessorClassName = accessorClassName;
        }
    }
}

