/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageGeneratorConfig;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Generated match processor implementation inferrer.
 * 
 * @author Mark Czotter
 * @noreference
 */
@SuppressWarnings("all")
public class PatternMatchProcessorClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  private IErrorFeedback feedback;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  /**
   * Infers the {@link Consumer} implementation class from a {@link Pattern}.
   */
  public JvmDeclaredType inferProcessorClass(final Pattern pattern, final boolean isPrelinkingPhase, final String processorPackageName, final JvmType matchClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder, final EMFPatternLanguageGeneratorConfig config) {
    this.builder = builder;
    this.annBuilder = annBuilder;
    final Procedure1<JvmGenericType> _function = (JvmGenericType it) -> {
      EMFPatternLanguageGeneratorConfig.MatcherGenerationStrategy _matcherGenerationStrategy = config.getMatcherGenerationStrategy();
      boolean _equals = Objects.equal(_matcherGenerationStrategy, EMFPatternLanguageGeneratorConfig.MatcherGenerationStrategy.NESTED_CLASS);
      it.setStatic(_equals);
      it.setPackageName(processorPackageName);
      this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocProcessorClass(pattern).toString());
      it.setAbstract(true);
      EList<JvmTypeReference> _superTypes = it.getSuperTypes();
      JvmTypeReference _typeRef = this.builder.typeRef(Consumer.class, this.builder.typeRef(matchClass));
      this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
      this._eMFJvmTypesBuilder.setFileHeader(it, this._eMFPatternLanguageJvmModelInferrerUtil.getFileComment(pattern));
    };
    final JvmGenericType processorClass = this._eMFJvmTypesBuilder.toClass(pattern, this._eMFPatternLanguageJvmModelInferrerUtil.processorClassName(pattern, config.getMatcherGenerationStrategy()), _function);
    return processorClass;
  }
  
  /**
   * Infers methods for Processor class based on the input 'pattern'.
   */
  public Boolean inferProcessorClassMethods(final JvmDeclaredType processorClass, final Pattern pattern, final JvmType matchClassRef) {
    boolean _xtrycatchfinallyexpression = false;
    try {
      boolean _xblockexpression = false;
      {
        EList<JvmMember> _members = processorClass.getMembers();
        final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
          it.setReturnType(this.builder.typeRef(Void.TYPE));
          this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocProcessMethod(pattern).toString());
          it.setAbstract(true);
          EList<Variable> _parameters = pattern.getParameters();
          for (final Variable parameter : _parameters) {
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(parameter, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter));
            this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
          }
        };
        JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "accept", null, _function);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        EList<JvmMember> _members_1 = processorClass.getMembers();
        final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
          it.setReturnType(this.builder.typeRef(Void.TYPE));
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
          this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(pattern, "match", this.builder.typeRef(matchClassRef));
          this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("accept(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable p : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("match.");
                  String _terMethodName = PatternMatchProcessorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.getterMethodName(p);
                  _builder.append(_terMethodName);
                  _builder.append("()");
                }
              }
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          this._eMFJvmTypesBuilder.setBody(it, _client);
        };
        JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "accept", null, _function_1);
        _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      }
      _xtrycatchfinallyexpression = _xblockexpression;
    } catch (final Throwable _t) {
      if (_t instanceof IllegalStateException) {
        final IllegalStateException ex = (IllegalStateException)_t;
        this.feedback.reportError(pattern, ex.getMessage(), IssueCodes.OTHER_ISSUE, Severity.ERROR, 
          IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return Boolean.valueOf(_xtrycatchfinallyexpression);
  }
}
